% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_output.R
\name{generate_output}
\alias{generate_output}
\title{Generate output and apply filters, titles, and footnotes}
\usage{
generate_output(program, datasets, spec, verbose_level = 2, ...)
}
\arguments{
\item{program}{program name}

\item{datasets}{list of datasets}

\item{spec}{spec}

\item{verbose_level}{Verbose level of messages be displayed. See details for further information.}

\item{...}{arguments passed to program}
}
\value{
No return value, called for side effects
}
\description{
Generate output and apply filters, titles, and footnotes
}
\details{
`verbose_level` is used to control how many messages are printed out.
By default, `2` will show all filter messages and show output generation message.
`1` will show output generation message only.
`0` will display no message.
}
\examples{
\dontshow{if (require(filters)) withAutoprint(\{ # examplesIf}
library(dplyr)
filters::load_filters(
  yaml_file = system.file("filters.yml", package = "autoslider.core"),
  overwrite = TRUE
)

spec_file <- system.file("spec.yml", package = "autoslider.core")
spec <- spec_file \%>\% read_spec()

data <- list(
  adsl = eg_adsl,
  adae = eg_adae
)
generate_output("t_ae_slide", data, spec$t_ae_slide_SE)
\dontshow{\}) # examplesIf}
}
\author{
Liming Li (`Lil128`)
}
