% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$vss}
\alias{AUTO_VI$vss}
\title{Predict the visual signal strength}
\arguments{
\item{p}{\code{ggplot}/List/Data.frame/Array/Numpy array/String. The input can be
\enumerate{
\item a \code{ggplot},
\item a list of \code{ggplot},
\item a data.frame containing
\code{.resid} (residuals) and \code{.fitted} (fitted values) that can be passed to
\code{\link[=AUTO_VI$plot_resid]{AUTO_VI$plot_resid()}},
\item a 3D array representing an image,
\item a 4D array representing one or more images,
\item a path to an image,
\item a vector or a list of paths to images,
\item a numpy array.
}}

\item{auxiliary}{Dataframe. A dataframe of auxiliary values. This is only used
when the keras model has multiple inputs. If it is not provided, the
values will be automatically computed based on the residual plot of the
fitted model. See also \code{\link[=AUTO_VI$auxiliary]{AUTO_VI$auxiliary()}}.}

\item{keras_model}{Keras model. A trained computer vision model.}

\item{node_index}{Integer. An index indicating which node of the output layer
contains the visual signal strength. This is particularly useful
when the keras model has more than one output nodes.}

\item{extract_feature_from_layer}{Character/Integer. A layer name or an
integer layer index for extracting features from a layer.}
}
\value{
A tibble. The first column is \code{vss} which is the prediction, the
rest of the columns are features extracted from a layer.
}
\description{
This function predicts the visual signal strength.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$vss(
  p = self$plot_resid(),
  auxiliary = NULL,
  keras_model = self$keras_model,
  node_index = self$node_index,
  extract_feature_from_layer = NULL
)
}\if{html}{\out{</div>}}
}
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$vss()
}

}
