% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aves_peru_2025_v3.R
\docType{data}
\name{aves_peru_2025_v3}
\alias{aves_peru_2025_v3}
\title{aves_peru_2025_v3}
\format{
A tibble with 1,914 rows and 6 columns:
\describe{
\item{order_name}{Taxonomic order to which the bird species belongs.}
\item{family_name}{Taxonomic family to which the bird species belongs.}
\item{scientific_name}{Scientific name of the bird species.}
\item{english_name}{English common name of the bird species.}
\item{spanish_name}{Spanish common name of the bird species.}
\item{status}{Category indicating the species' status, based on the following codes:
\itemize{
\item{\code{X}}: Resident species.
\item{\code{E}}: Endemic species. A species is considered endemic to Peru until a record outside its borders is published.
\item{\code{NB}}: Non-breeding (migratory) species. Species that occur regularly in Peru but only during their non-breeding period.
\item{\code{V}}: Vagrant species. Species that occasionally occur in Peru but are not part of the usual avifauna.
\item{\code{IN}}: Introduced species. Species introduced to Peru by humans (or have colonized from introduced populations elsewhere) and have established self-sustaining breeding populations.
\item{\code{H}}: Hypothetical species. Records based only on observations, specimens of dubious origin, or unpublished photographs or recordings kept in private hands.
\item{\code{EX}}: Extinct or extirpated species. Species that have gone extinct or have been extirpated from Peru.
}
}
}
}
\usage{
aves_peru_2025_v3
}
\description{
The \code{aves_peru_2025_v3} dataset provides an updated tibble of bird
species recorded in Peru, based on the most recent taxonomic revisions
by the South American Checklist Committee (SACC).
}
\details{
This version reflects dramatic taxonomic changes and category updates
based on published articles, photographs, and sound recordings archived
in accredited institutions. It also includes a classification criterion
following the SACC guidelines. Species without a specific code are considered
resident species, equivalent to the "X" category of the SACC.
\itemize{
\item \strong{Total species}: 1,912
\item \strong{Distribution by status}:
\itemize{
\item{\code{X}}: 1,545 species
\item{\code{E}}: 119 species
\item{\code{NB}}: 139 species
\item{\code{V}}: 85 species
\item{\code{IN}}: 3 species
\item{\code{EX}}: 0 species
\item{\code{H}}: 23 species
}
}

These updates reflect the SACC’s continuous evaluation process, which now recognizes several former subspecies as full species.
}
\examples{
# Load the dataset
data("aves_peru_2025_v3")

}
\references{
Plenge, M. A. Version (23-06-2025) List of the birds of Peru / Lista de
las aves del Perú. Unión de Ornitólogos del Perú:
\url{https://sites.google.com/site/boletinunop/checklist}
}
\seealso{
For more information about the data, visit:
\url{https://sites.google.com/site/boletinunop/checklist}
}
\author{
Data compilation: Manuel A. Plenge
Package implementation: Paul Efren Santos Andrade
}
\keyword{Peru}
\keyword{SACC}
\keyword{birds}
\keyword{dataset}
\keyword{ornithology}
\keyword{taxonomy}
