% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_default.R
\name{plot.Explain}
\alias{plot.Explain}
\title{A Function for Visualizing the Shapley Values}
\usage{
\method{plot}{Explain}(
  x,
  average = NULL,
  type = NULL,
  num_post = NULL,
  plot.flag = TRUE,
  adjust = FALSE,
  probs = 0.95,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{Explain} class object containing the Shapley values of models.}

\item{average}{Input the reference value for calculating the mean of the object's \code{phi} list.
\code{"obs"} represents the average based on observations (#post by #variable),
while \code{"post"} represents the average based on posterior samples (#obs by #variable).
If \code{"both"} is entered, calculations are performed based on both observation and posterior sample criteria.
If no value is specified, "both" is used as the default.}

\item{type}{\code{"bar"} represents a bar chart that includes the average contribution of each variable,
while \code{"bee"} represents a summary plot, allowing you to determine the graph's format.}

\item{num_post}{To check the contribution of variables for a single posterior sample,
enter a value within the number of posterior samples.}

\item{plot.flag}{If \code{average = "obs"}, the quantile interval of each variable's is provided by default.}

\item{adjust}{The default value is \code{FALSE}.
Enter \code{TRUE} to check the Shapley values adjusted based on the model's average contribution.}

\item{probs}{Enter the probability for the quantile interval. The default value is \code{0.95}.}

\item{title}{The title of the plot, with a default value of \code{NULL}.}

\item{xlab}{Enter the label to be displayed on the x-axis. If not provided, a default label will be used.}

\item{ylab}{Enter the label for the y-axis if needed.}

\item{...}{Additional arguments to be passed}
}
\value{
The plot is returned based on the specified option.: 
\item{out}{If average is \code{"obs"} or \code{"post"}, a bar plot or summary plot is generated based on the selected averaging criterion. 
When \code{average} is set to \code{"both"}, either a bar plot or a boxplot comparing the distributions of Shapley values computed under the two averaging criteria is generated.
In the case where a boxplot is produced, the observation-based and posterior-sample-based summaries can additionally be rendered separately
via \code{out$observation} and \code{out$post}, respectively.
If adjust is \code{TRUE}, the adjusted Shapley values are displayed.
If \code{num_post} is specified, a bar plot or summary plot for the selected posterior sample is generated.}
}
\description{
The \code{plot.Explain} function provides various visualization methods for Shapley values. 
The values and format used in the graph are determined based on the input parameters.
}
