% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting_triangle-getters.R
\name{get_quantile_delay}
\alias{get_quantile_delay}
\title{Get quantile delay for each row of reporting_triangle}
\usage{
get_quantile_delay(x, p = 0.99)
}
\arguments{
\item{x}{A reporting_triangle object}

\item{p}{Numeric value between 0 and 1 indicating the quantile to compute.
For example, p = 0.99 returns the delay at which 99\% of cases have been
reported. Default is 0.99.}
}
\value{
Vector of quantile delays for each reference date (integer). Returns
NA for rows with no observations.
}
\description{
Get quantile delay for each row of reporting_triangle
}
\examples{
# Get 99th percentile delay for each reference date
quantile_delays_99 <- get_quantile_delay(example_reporting_triangle)
quantile_delays_99

# Get median delay
median_delays <- get_quantile_delay(example_reporting_triangle, p = 0.5)
median_delays
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
