% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesJeffreys.R
\name{BayesJeffreys}
\alias{BayesJeffreys}
\title{Estimating the Student's t degrees of freedom (dof) with a Jeffreys Prior over the dof}
\usage{
BayesJeffreys(
  y,
  ini.nu = 1,
  S = 1000,
  delta = 0.001,
  sampling.alg = c("MH", "MALA")
)
}
\arguments{
\item{y}{an N-dimensional vector of continuous observations supported on the real-line}

\item{ini.nu}{the initial posterior sample value of the degrees of freedom (default is 1)}

\item{S}{the number of posterior samples (default is 1000)}

\item{delta}{the step size for the respective sampling engines (default is 0.001)}

\item{sampling.alg}{takes the choice of the sampling algorithm to be performed, either 'MH' or 'MALA'}
}
\value{
A vector of posterior sample estimates
\item{res}{an S-dimensional vector with the posterior samples}
}
\description{
\code{BayesJeffreys} samples from the posterior distribution of the degrees of freedom (dof) with Jeffreys prior endowed upon the dof, using a random walk Metropolis (RMW) algorithm and Metropolis-adjusted Langevin algorithm (MALA).
}
\examples{

# data from Student's t-distribution with dof = 0.1
y = rt(n = 100, df = 0.1)

# running the random walk Metropolis algorithm with default settings
nu1 = BayesJeffreys(y, sampling.alg = "MH")
# reporting the posterior mean estimate of the dof
mean(nu1)

# running MALA with default settings
nu2 = BayesJeffreys(y, sampling.alg = "MALA")
# reporting the posterior mean estimate of the dof
mean(nu2)

# application to log-return (daily index values) of United States (S&P500)
data(index_return)
# log-returns of United States
index_return_US <- dplyr::filter(index_return, Country == "United States")
y = index_return_US$log_return_rate

# running the random walk Metropolis algorithm with default settings
nu1 = BayesJeffreys(y, sampling.alg = "MH")
# reporting the posterior mean estimate of the dof from the log-return data of US
mean(nu1)

# running MALA with default settings
nu2 = BayesJeffreys(y, sampling.alg = "MALA")
# reporting the posterior mean estimate of the dof from the log-return data of US
mean(nu2)

}
\references{
Lee, S. Y. (2022). "The Use of a Log-Normal Prior for the Student t-Distribution",
\emph{Axioms}, \doi{10.3390/axioms11090462}

Gustafson, P. (1998). "A guided walk Metropolis algorithm",
\emph{Statistics and Computing}, \doi{10.1023/A:1008880707168}
}
