% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{InUnitParams}
\alias{InUnitParams}
\alias{ABXInUnitParams}
\title{In Unit Parameters}
\usage{
InUnitParams(
  acquisition = LinearAbxAcquisitionParams(),
  progression = ProgressionParams(),
  clearance = ClearanceParams()
)

ABXInUnitParams(
  acquisition = LinearAbxAcquisitionParams(),
  progression = ProgressionParams(),
  clearance = ClearanceParams()
)
}
\arguments{
\item{acquisition}{Acquisition, for rate of acquisition of the disease moving into
colonized(2-State)/latent(3-state) state.}

\item{progression}{Progression from latent state to colonized state.}

\item{clearance}{Clearance from colonized state to uncolonized state.}
}
\value{
A list of parameters for in unit infection.
}
\description{
In Unit Parameters
}
\section{Functions}{
\itemize{
\item \code{ABXInUnitParams()}: In Unit Parameters with Antibiotics.

}}
\examples{
InUnitParams(
  acquisition = LinearAbxAcquisitionParams(),
  progression = ProgressionParams(),
  clearance = ClearanceParams()
)
ABXInUnitParams(
  acquisition = LinearAbxAcquisitionParams(),
  progression = ProgressionParams(),
  clearance = ClearanceParams()
)
}
