% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bcmmrm.R
\name{plot.bcmmrm}
\alias{plot.bcmmrm}
\title{Plot a bcmmrm Object.}
\usage{
\method{plot}{bcmmrm}(
  x,
  robust = TRUE,
  ssadjust = TRUE,
  dt = 1,
  timepoint = NULL,
  tnom = TRUE,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  lwd = 2,
  col = NULL,
  lty = NULL,
  main = TRUE,
  sub = NULL,
  legend = TRUE,
  loc = "topright",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{an object inheriting from class "\code{bcmmrm}", representing
the Box-Cox transformed MMRM analysis.}

\item{robust}{an optional logical value used to specify whether to apply
the robust inference. The default is \code{TRUE}.}

\item{ssadjust}{an optional logical value used to specify whether to apply
the empirical small sample adjustment. The default is \code{TRUE}.}

\item{dt}{an numeric value indicating shift length between groups
in the longitudinal median plot. A multiplying factor for the default
settings specified (e.g. if \code{2} is specified,
shift length is twice longer than that for the default setting).
The default is \code{1}.}

\item{timepoint}{an numeric value of a specified level of \code{time}
variable at which median plot is created. When \code{timepoint} is
\code{NULL} and number of time points is not 1, longitudinal median plot
(x axis is \code{time}) is created. Otherwise, median plot where
x axis is \code{group} is created. The default is \code{NULL}.}

\item{tnom}{a optional logical value indicating the scale of x axis
of the longitudinal median plot. When \code{tnom} is \code{TRUE}, nominal
scale is used and widths between any combinations of neighbor time points
are same. When \code{tnom} is \code{FALSE}, actual scale of \code{time}
variable is used. The default is \code{TRUE}.}

\item{xlab}{a title for the x axis. The default is \code{NULL} and
the name of \code{time} or \code{group} variable is used.}

\item{ylab}{a title for the y axis. The default is \code{NULL} and
the name of \code{outcome} variable is used.}

\item{xlim}{a numeric vector with length of 2 indicating limits of x
axis. The default is \code{NULL} and limits are calculated automatically.}

\item{ylim}{a numeric vector with length of 2 indicating limits of y
axis. The default is \code{NULL} and limits are calculated automatically.}

\item{lwd}{an optional positive numeric value indicating line width.
The default is \code{2}.}

\item{col}{an integer or a character vector with length of the number of
groups indicating colors of lines for each treatment group. The default is
\code{NULL} and all of colors are black.}

\item{lty}{an optional integer or a character vector with length of the
number of groups indicating line types of lines for each treatment group.
The default is \code{NULL} and \code{1:ng} is used, where ng is number of
groups.}

\item{main}{a main title for the plot. The default is \code{TRUE} and
default title is "(Longitudinal) Plot for median of each group".}

\item{sub}{a sub title for the plot. The default is \code{NULL}.}

\item{legend}{a logical optional value specifying to add legends to
plots. When \code{legend} is \code{TRUE} legends are added to the plot.
Otherwise, legends are not added.  The default is \code{TRUE}.}

\item{loc}{a character value indicating the location of the legends.
The location can be specified by setting \code{loc} to a single keyword
from the list \code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"},
\code{"left"}, \code{"topleft"}, \code{"top"}, \code{"topright"},
\code{"right"}, and \code{"center"}. The default is \code{"topright"}.}

\item{verbose}{a logical optional value specifying to print the detailed
analysis information in the console. The default is \code{FALSE}.}

\item{...}{some methods for this generic require additional arguments.}
}
\value{
a median plot.
}
\description{
Plot for the model medians of each treatment groups with the 95 percent
confidence intervals stored in \code{bcmmrmObject}.
}
\examples{
 data(aidscd4)
 resar <- bcmmrm(outcome = cd4, group = treatment, data = aidscd4,
                time = weekc, id = id, structure = "AR(1)", glabel =
                c("Zid/Did", "Zid+Zal", "Zid+Did", "Zid+Did+Nev"))
 plot(resar, xlab = "Week", ylab = "CD4+1", col = 1:4, main = NULL)
 plot(resar, timepoint = 32, xlab = "Treatment", ylab = "CD4+1")
}
\seealso{
\code{\link{bcmmrm}}, \code{\link{bcmmrmObject}}
}
