% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makebasis.R
\name{makebasis}
\alias{makebasis}
\title{Make orthonomal basis for weight functions}
\usage{
makebasis(exposure, df)
}
\arguments{
\item{exposure}{Matrix of repeated measures of exposure that is n x T where n is the number of observations and T is the number of time points.}

\item{df}{Degrees of freedom (including intercept) for the natural spline basis to be used.}
}
\value{
A matrix with orthonormal basis expansions of exposure time. The matrix is T x df. These have the span of natural splines with an intercept and df degrees of freedom.
}
\description{
Make orthonomal basis for weight functions
}
\examples{
  B <- makebasis(sbd_bdlim[,paste0("pm25_",1:37)], df=4)
}
