% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumatraInitialize.R
\name{sumatraInitialize}
\alias{sumatraInitialize}
\title{Set useful Sumatra PDF Viewer default settings}
\usage{
sumatraInitialize(
  path = sumatraPaths()[1],
  roampath = sumatraPaths()[2],
  openfolder = TRUE
)
}
\arguments{
\item{path}{Folder (not file) that contains "SumatraPDF.exe".
You need file writing permissions in the folder.
DEFAULT: equivalent of "C:/Program Files/RStudio/resources/app/bin/sumatra"}

\item{roampath}{Folder that will contain "SumatraPDF-settings.txt".
DEFAULT: equivalent of "C:/Users/berry/AppData/Roaming/SumatraPDF"}

\item{openfolder}{Logical: Open folders after writing the files?
Uses \code{\link{openFile}()}. DEFAULT: TRUE}
}
\value{
path, invisibly
}
\description{
Set useful Sumatra PDF Viewer default settings. This will only work on windows.
Existing files are renamed ("_old_n" appended), not overwritten.\cr
At the given \code{path} with "SumatraPDF.exe", it creates "sumatrapdfrestrict.ini" with \code{SavePreferences = 1} and \code{FullscreenAccess = 1}.\cr
At the given \code{roampath}, it creates "SumatraPDF-settings.txt" with \code{ShowToc = false} and \code{DefaultDisplayMode = single page}.
\code{UiLanguage} gets filled in by Sumatra itself upon first opening.
}
\examples{
# sumatraInitialize() # only run in interactive mode

}
\seealso{
\code{\link{openPDF}}\cr
\url{https://www.sumatrapdfreader.org/settings/settings.html}\cr
\url{https://github.com/sumatrapdfreader/sumatrapdf/blob/master/docs/sumatrapdfrestrict.ini}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2020, Nov 2023
}
\keyword{file}
