% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_boin_oc.R
\name{sim.one.trial}
\alias{sim.one.trial}
\title{Simulate one BF-BOIN trial}
\usage{
sim.one.trial(
  trial.id = 1,
  target = 0.25,
  p.true = c(0.1, 0.3, 0.5),
  ncohort = 10,
  cohortsize = 3,
  n.earlystop = 100,
  startdose = 1,
  titration = FALSE,
  p.saf = 0.6 * target,
  p.tox = 1.4 * target,
  cutoff.eli = 0.95,
  extrasafe = FALSE,
  offset = 0.05,
  boundMTD = FALSE,
  n.cap = 12,
  end.backfill = TRUE,
  n.per.month = 3,
  dlt.window = 1,
  p.response.true = c(1, 1, 1),
  three.plus.three = FALSE,
  accrual = "uniform",
  backfill.assign = "highest"
)
}
\arguments{
\item{trial.id}{an ID for the trial}

\item{target}{the target DLT rate}

\item{p.true}{a vector containing the true toxicity probabilities of the
investigational dose levels.}

\item{ncohort}{the total number of cohorts}

\item{cohortsize}{the cohort size}

\item{n.earlystop}{the early stopping parameter. If the number of patients
treated at the current dose reaches \code{n.earlystop},
stop the trial and select the MTD based on the observed data.
The default value \code{n.earlystop=100} essentially turns
off this type of early stopping.}

\item{startdose}{the starting dose level for the trial}

\item{titration}{set \code{titration=TRUE} to perform dose escalation with cohort size = 1 to accelerate dose escalation at the begining of the trial.}

\item{p.saf}{the highest toxicity probability that is deemed subtherapeutic
(i.e. below the MTD) such that dose escalation should be undertaken.
The default value is \code{p.saf=0.6*target}.}

\item{p.tox}{the lowest toxicity probability that is deemed overly toxic such
that deescalation is required. The default value is
\code{p.tox=1.4*target}).}

\item{cutoff.eli}{the cutoff to eliminate an overly toxic dose for safety.
We recommend the default value of (\code{cutoff.eli=0.95}) for general use.}

\item{extrasafe}{set \code{extrasafe=TRUE} to impose a more stringent stopping rule}

\item{offset}{a small positive number (between \code{0} and \code{0.5}) to control how strict the
stopping rule is when \code{extrasafe=TRUE}. A larger value leads to a more
strict stopping rule. The default value \code{offset=0.05} generally works well.}

\item{boundMTD}{set \code{boundMTD=TRUE} to impose the condition: the isotonic estimate of toxicity probability
for the selected MTD must be less than de-escalation boundary.}

\item{n.cap}{permanently close a dose for backfilling if the number of patients assigned
to the dose reaches \code{n.cap}}

\item{end.backfill}{when the dose escalation ends, the backfilling by definition also ends. Default is TRUE.}

\item{n.per.month}{patient accrual rate per month}

\item{dlt.window}{DLT assessment window (months)}

\item{p.response.true}{a vector containing the true response probabilities of the
investigational dose levels}

\item{three.plus.three}{modify the decision from de-escalation to stay when observing
1 DLT out of 3 patients}

\item{accrual}{"uniform" or "poisson", according to whether accrual distribution is uniform
(consistent with Shiny App) or a Poisson process (consistent with publication)}

\item{backfill.assign}{How to assign backfill dose given the open backfill doses. Options are
"highest" (default), "lowest", or "random".}
}
\value{
A data frame with the number of patients and number of DLTs at each dose level
}
\description{
Simulate one BF-BOIN trial
}
