% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_R2.R
\name{bf_R2}
\alias{bf_R2}
\title{R² for Cluster Solutions after Buttler & Fickel (1995)}
\usage{
bf_R2(D, cluster)
}
\arguments{
\item{D}{A distance object of class \code{dist}, usually computed via
\code{buttler_fickel_dist()}.}

\item{cluster}{An integer or factor vector of cluster assignments,
typically obtained from \code{cutree()} or another clustering method.}
}
\value{
A numeric value between 0 and 1 indicating the proportion of
explained distance variation. Higher values represent better cluster fit.
}
\description{
Computes the proportion of explained distance variation (R²) for a given
clustering solution using a distance matrix derived from the
Buttler-Fickel distance. The statistic reflects how well the clustering
partitions the total pairwise distance structure.
}
\details{
The R² is defined as:
\deqn{R^2 = 1 - \frac{D_{\text{within}}}{D_{\text{total}}}}
where \eqn{D_{\text{total}}} is the sum of all pairwise distances and
\eqn{D_{\text{within}}} is the sum of distances within clusters.
}
\examples{
df <- data.frame(
  sex    = factor(c("m","f","m","f")),
  height = c(180, 165, 170, 159),
  age    = c(25, 32, 29, 28)
)

types <- c("nominal", "metric", "metric")

D <- buttler_fickel_dist(df, types)
hc <- hclust(D)
cl <- cutree(hc, k = 2)

bf_R2(D, cl)

}
