% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplotgr.r
\name{barplotgr}
\alias{barplotgr}
\title{Function for building a barplot for one or two factors}
\usage{
barplotgr(
  yvar,
  factors,
  data = data,
  percentage = FALSE,
  errbar = !percentage,
  half.errbar = TRUE,
  conf.level = 0.95,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  names.arg = NULL,
  bar.col = "black",
  whisker = 0.015,
  args.errbar = NULL,
  legend = TRUE,
  legend.text = NULL,
  args.legend = NULL,
  legend.border = FALSE,
  box = TRUE,
  args.yaxis = NULL,
  mar = c(5, 4, 3, 2),
  ...
)
}
\arguments{
\item{yvar}{The column having the variable to represent the height of
the bars.}

\item{factors}{A vector having the columns with the factors to be used
in the resulting plot. Notice that the last listed factor, will be used
in X-axis plot.}

\item{data}{A data frame having the above described columns.}

\item{percentage}{Logical value, set to \code{FALSE}.}

\item{errbar}{Please set this option to \code{FALSE}.}

\item{half.errbar}{Optional, default set to \code{TRUE}.}

\item{conf.level}{Optional, a numeric value for the confidence interval,
the default is 0.95.}

\item{xlab}{Optional, as in the generic barplot function.}

\item{ylab}{Optional, as in the generic barplot function.}

\item{main}{Optional, as in the generic barplot function.}

\item{names.arg}{Optional, as in the generic barplot function.}

\item{bar.col}{Optional, as in the generic barplot function.}

\item{whisker}{Optional, A numeric value, the default is 0.015.}

\item{args.errbar}{Optional, as in the generic barplot function.}

\item{legend}{Optional, as in the generic barplot function.}

\item{legend.text}{Optional, as in the generic barplot function.}

\item{args.legend}{Optional, as in the generic barplot function.}

\item{legend.border}{Optional, as in the generic barplot function.}

\item{box}{Optional, as in the generic barplot function.}

\item{args.yaxis}{Optional, as in the generic barplot function.}

\item{mar}{Optional, as in the generic barplot function.}

\item{...}{list of columns to sort on}
}
\value{
The function returns the above described graph.
}
\description{
The function creates a barplot of numeric vector by one or two
factor.
}
\examples{
data(standtabRauli2)
df <- standtabRauli2
head(df)
barplotgr(yvar = nha.cd, factors = c(bosque.id,cd), data = df,
errbar = FALSE, ylim=c(0, 640))
}
\references{
The present function was modified from a similar one available at
\url{https://github.com/mrxiaohe/R_Functions/blob/master/functions/bar}
}
\author{
Christian Salas-Eljatib
}
