% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_misc_operations.R
\name{seq_disambiguate_IUPAC}
\alias{seq_disambiguate_IUPAC}
\title{Disambiguate biological sequences}
\usage{
seq_disambiguate_IUPAC(x)
}
\arguments{
\item{x}{a DNA, RNA or AA vector}
}
\value{
A list of DNA, RNA or AA vectors (depending on the input)
giving all possible combinations.
}
\description{
This function finds all the combinations of sequences corresponding
to a given vector of sequences with ambiguities (IUPAC codes).
}
\examples{

x <- dna(c("AYCTGW", "CTTN"))
seq_disambiguate_IUPAC(x)

y <- seq_transcribe(x)
seq_disambiguate_IUPAC(y)

z <- aa("YJSNAALNX")
z <- seq_translate(y)
seq_disambiguate_IUPAC(z)

}
\seealso{
Other op-misc: 
\code{\link{seq_nchar}()},
\code{\link{seq_nseq}()},
\code{\link{seq_spellout}()},
\code{\link{seq_stat_gc}()},
\code{\link{seq_stat_prop}()}
}
\concept{op-misc}
