% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birdnet_interface.R
\name{read_labels}
\alias{read_labels}
\title{Read species labels from a file}
\usage{
read_labels(species_file)
}
\arguments{
\item{species_file}{Path to species file.}
}
\value{
A vector with class labels e.g. c("Cyanocitta cristata_Blue Jay", "Zenaida macroura_Mourning Dove")
}
\description{
This is a convenience function to read species labels from a file.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read a custom species file
read_labels(system.file("extdata", "species_list.txt", package = "birdnetR"))

# To access all class labels that are supported in your language,
# you can read in the respective label file
\dontrun{
model <- birdnet_model_tflite(version = "v2.4", language = "en_us")
labels_path <- labels_path(model, "fr")
species_list <- read_labels(labels_path)
head(species_list)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=available_languages]{available_languages()}} \code{\link[=labels_path]{labels_path()}}
}
