% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history_parameter.R
\name{history_parameter}
\alias{history_parameter}
\title{Extract values of used or fitted history parameter}
\usage{
history_parameter(
  object,
  param,
  summary = TRUE,
  probs = c(0.055, 0.945),
  includePopulationLevel = TRUE
)
}
\arguments{
\item{object}{An object of class \link[=cumhist-class]{cumhist}}

\item{param}{Parameter name: \code{"tau"} or \code{"mixed_state"}}

\item{summary}{Whether summary statistics should be returned instead of
raw sample values. Defaults to \code{TRUE}}

\item{probs}{The percentiles used to compute summary, defaults to 89\% credible interval.}

\item{includePopulationLevel}{Logical, for pooled random effect only. Whether to include
population mean as a separate \code{"_population"} level, default to \code{TRUE}.}
}
\value{
A vector, if summary was not requested. Or a tibble with a summary or if a fixed value was used.
}
\description{
Extract values of used or fitted history parameter
}
\examples{
\donttest{
br_fit <- fit_cumhist(br_singleblock, state="State", duration="Duration")
history_parameter(br_fit, "tau")
}
}
