% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_map.R
\name{bf_map}
\alias{bf_map}
\title{Build a bit flag}
\usage{
bf_map(
  protocol,
  data,
  ...,
  name = NULL,
  pos = NULL,
  na.val = NULL,
  description = NULL,
  registry = NULL
)
}
\arguments{
\item{protocol}{\code{\link[=character]{character(1)}}\cr the protocol based on which
the flag should be determined, see Details.}

\item{data}{the object to build bit flags for.}

\item{...}{the protocol-specific arguments for building a bit flag, see Details.}

\item{name}{\code{\link[=character]{character(1)}}\cr optional flag-name.}

\item{pos}{\code{\link[=integer]{integerish(.)}}\cr the position(s) in the bitfield that
should be set.}

\item{na.val}{value, of the same encoding type as the flag, that needs to be
given, if the test for this flag results in \code{NA}s.}

\item{description}{\code{\link[=character]{character(.)}}\cr optional description that
should be used instead of the default protocol-specific description. This
description is used in the registry legend, so it should have as many
entries as there will be flags (two for a binary flag, as many as there are
cases for a enumeration flag and one for integer or numeric flags).}

\item{registry}{\code{\link[=registry]{registry(1)}}\cr a bitfield registry that has
been defined with \code{\link{bf_registry}}; if it's undefined, an empty
registry will be defined on-the-fly.}
}
\value{
an (updated) object of class 'registry' with the additional flag
defined here.
}
\description{
This function maps values from a dataset into bit flags that can be encoded
into a bitfield.
}
\details{
\code{protocol} can either be the name of an internal item
\code{\link{bf_pcl}}, a newly built local protocol or one that has been
imported from the bitfield community standards repo on github. Any
\code{protocol} has specific arguments, typically at least the name of the
column containing the variable values (\code{x}). To make this function as
general as possible, all of these arguments are specified via the
\code{...} argument of \code{bf_map}. Internal
protocols are: \itemize{
\item \code{na} (x): test whether a variable contains \code{NA}-values
(\emph{boolean}).
\item \code{nan} (x): test whether a variable contains \code{NaN}-values
(\emph{boolean}).
\item \code{inf} (x): test whether a variable contains \code{Inf}-values
(\emph{boolean}).
\item \code{identical} (x, y): element-wise test whether values are
identical across two variables (\emph{boolean}).
\item \code{range} (x, min, max): test whether the values are within a
given range (\emph{boolean}).
\item \code{matches} (x, set): test whether the values match a given set
(\emph{boolean}).
\item \code{grepl} (x, pattern): test whether the values match a given
pattern (\emph{boolean}).
\item \code{case} (...): test whether values are part of given cases
(\emph{enumeration}).
\item \code{nChar} (x): count the number of characters of the values
(\emph{unsigned integer}).
\item \code{nInt} (x): count the number of integer digits of the values
(\emph{unsigned integer}).
\item \code{nDec} (x): count the decimal digits of the variable values
(\emph{unsigned integer}).
\item \code{integer} (x, ...): encode the integer values as bit-sequence
(\emph{signed integer}).
\item \code{numeric} (x, ...): encode the numeric value as floating-point
bit-sequence (with an adapted precision) (\emph{floating-point}).
}
}
\section{Notes}{
 The console output of various classes (such as tibble) shows
decimals that are not present or rounds decimals that are present, even for
ordinary numeric vectors. R stores numeric values internally as
double-precision floating-point values (with 64 bits, where 52 bits encode
the mantissa), which corresponds to a decimal precision of ~16 digits
(\code{log10(2^52)}). Hence, if a bit flag doesn't seem to coincide with
the values you see in the console, double check the values with
\code{sprintf("\%16f", values)}. If you use a larger decimal precision,
you'll see more digits, but those are not meaningful, as they result merely
from the binary-to-decimal conversion (check out
\code{\link{.makeEncoding}} for additional information.

When testing for cases, they are evaluate in the order they have been
defined in. If an observation is part of two cases, it will thus have the
value of the last case it matches. The encoding type of cases is given as
\emph{enumeration}, which means that the values can be either
\code{integer} or \code{factor}. Both are handled as if they were integers
internally, so even though an enumeration data type could in principle also
be a \code{character}, this is possible within the scope of this package.
Bitflag protocols that extend the \emph{case} protocol must thus always
result in integer values.
}

\examples{
opr <- "identical"

# identify which arguments need to be given to call a test ...
formalArgs(bf_pcl[[opr]]$test)

# put the test together
bf_map(protocol = opr, data = bf_tbl, x = x, y = y, na.val = FALSE)

# some other examples of ...
# boolean encoding
bf_map(protocol = "matches", data = bf_tbl, x = commodity, set = c("soybean", "honey"))
bf_map(protocol = "range", data = bf_tbl, x = yield, min = 10.4, max = 11)

# enumeration encoding
bf_map(protocol = "case", data = bf_tbl,
        yield >= 11, yield < 11 & yield > 9, yield < 9 & commodity == "maize")

# integer encoding
bf_map(protocol = "integer", data = bf_tbl, x = as.integer(year), na.val = 0L)

# floating-point encoding
bf_map(protocol = "numeric", data = bf_tbl, x = yield, decimals = 2)

}
