% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_compose.R
\name{bm_compose}
\alias{bm_compose}
\title{Compose graphemes in a bitmap list by applying combining marks}
\usage{
bm_compose(bml, pua_combining = character(0), ...)
}
\arguments{
\item{bml}{A \code{bm_list()} object.
All combining marks need appropriate Unicode code point names
to be recognized by \code{\link[=is_combining_character]{is_combining_character()}}.}

\item{pua_combining}{Additional Unicode code points to be considered
as a \dQuote{combining} character such as characters
defined in the Private Use Area (PUA) of a font.}

\item{...}{Passed to \code{\link[=bm_overlay]{bm_overlay()}}.}
}
\value{
A \code{bm_list()} object.
}
\description{
\code{bm_compose()} simplifies \code{bm_list()} object
by applying combining marks to preceding glpyhs (composing new graphemes).
}
\details{
\code{bm_compose()} identifies combining marks by their name using \code{\link[=is_combining_character]{is_combining_character()}}.
It then combines such marks with their immediately preceding glyph using \code{\link[=bm_overlay]{bm_overlay()}}.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  grave <- font[[str2ucp("`")]]
  a <- font[[str2ucp("a")]]
  bml <- bm_list(`U+0061` = a, `U+0300` = grave)
  print(bml)
  print(bm_compose(bml))
}
