% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer-entropy.R
\name{prewhiten_bin_glm}
\alias{prewhiten_bin_glm}
\title{Pre-whiten binary series with logistic GLM}
\usage{
prewhiten_bin_glm(DT, yname)
}
\arguments{
\item{DT}{A \code{data.frame} or \code{data.table} containing the
binary response and covariates. It must include at least:
\itemize{
\item The binary variable named by \code{yname} (values 0/1).
\item \code{t_norm}: normalized time index.
\item \code{Regime}, \code{EconCycle}, \code{PopDensity},
\code{Epidemics}, \code{Climate}, \code{War}.
}}

\item{yname}{Character scalar; name of the binary response column in
\code{DT}. The function checks that all values are in \code{c(0, 1)}
and stops otherwise.}
}
\value{
A numeric vector of Pearson residuals (one per row in \code{DT}
used in the fit).
}
\description{
Fits a logistic regression (binomial GLM with logit link) to a binary
0/1 response and returns Pearson residuals as a pre-whitened series.
}
\examples{
\donttest{
if (interactive()) {
  n <- 100
  DT <- data.frame(
    t_norm = seq_len(n) / n,
    I_zero = rbinom(n, 1, 0.3),
    Regime = factor(sample(c("A","B"), n, TRUE)),
    EconCycle = rnorm(n), PopDensity = runif(n),
    Epidemics = rbinom(n, 1, 0.1), Climate = rnorm(n), War = rbinom(n, 1, 0.05)
  )
  r_I_zero <- prewhiten_bin_glm(DT, "I_zero")
  head(r_I_zero)
}
}
}
