% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EcoEDGE.R
\name{EcoEDGE}
\alias{EcoEDGE}
\title{EcoEDGE: Ecologically and Evolutionarily Distinct and Globally Endangered}
\usage{
EcoEDGE(
  category,
  phylo,
  func,
  funcweight = 0.5,
  phyloweight = 0.5,
  polytomy = "isaac"
)
}
\arguments{
\item{category}{data frame where the first column contains the red list categories of species.}

\item{phylo}{phylogenetic tree of species.}

\item{func}{functional dendrogram of species.}

\item{funcweight}{weight of ecological distinctiveness on the calculation of EcoEDGE scores.}

\item{phyloweight}{weight of evolutionary distinctiveness on the calculation of EcoEDGE scores. Sum of funcweight and phyloweight must be equal to 1.}

\item{polytomy}{how to handle polytomies in the phylogeny and the functional dendrogram. See "ed.calc" function for details.}
}
\value{
A table with calculated values for each variable.
}
\description{
Calculates ED, EcoD, EDGE, EcoDGE, and EcoEDGE, from Red List Categories, a phylogenetic tree, and a functional dendrogram.
}
\examples{
# https://rfunctions.blogspot.com/2021/03/ecoedge-ecologically-and-evolutionarily.html
}
