% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_spike.R
\name{table_spike}
\alias{table_spike}
\title{Make table summarizing the blind spikes.}
\usage{
table_spike(dat = bs_df)
}
\arguments{
\item{dat}{data frame with all data needed as described in `bs_prep_and_analysis`.}
}
\value{
table of all analytes in blind spike samples
}
\description{
Make a table showing how many blind spike samples contained one or more analytes.
}
\examples{
example_spike_data <- system.file('extdata', 'spikevals.csv', package = 'blindspiker')
example_lab_data <- system.file('extdata', 'labvals.csv', package = 'blindspiker')
example_df <- bs_prep_and_analysis(spike_data = example_spike_data, lab_data = example_lab_data)
table_spike(dat = example_df)

}
\seealso{
For combinations of analytes spiked in a single sample,
see `spike_combos`.
}
