% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-setup.R
\name{cmd_wd}
\alias{cmd_wd}
\alias{cmd_envvar}
\alias{cmd_envpath}
\alias{cmd_conda}
\title{Setup the context for the command}
\usage{
cmd_wd(command, wd = NULL)

cmd_envvar(command, ..., action = "replace", sep = NULL)

cmd_envpath(command, ..., action = "prefix", name = "PATH")

cmd_conda(command, ..., root = NULL, action = "prefix")
}
\arguments{
\item{command}{A \code{command} object.}

\item{wd}{A string or \code{NULL} define the working directory of the command.}

\item{...}{<\link[rlang:dyn-dots]{dynamic dots}>:
\itemize{
\item \code{cmd_envvar}: Named character define the environment variables.
\item \code{cmd_envpath}: Unnamed character to define the \code{PATH}-like environment
variables \code{name}.
\item \code{cmd_conda}: Unnamed character to specify the name of conda environment.
}}

\item{action}{Should the new values \code{"replace"}, \code{"prefix"} or \code{"suffix"}
existing environment variables?}

\item{sep}{A string to separate new and old value when \code{action} is \code{"prefix"}
or \code{"suffix"}. By default, \code{" "} will be used.}

\item{name}{A string define the PATH environment variable name. You
can use this to define other \code{PATH}-like environment variable such as
\code{PYTHONPATH}.}

\item{root}{A string specifying the path to the conda root prefix. By
default, it utilizes the \link[=Sys.getenv]{environment variable}
\code{BLIT_CONDA_ROOT} or the \link{option} \code{blit.conda.root}. If neither is set, the
root prefix of \code{\link[=appmamba]{appmamba()}} will be used.}
}
\value{
\itemize{
\item \code{cmd_wd}: The \code{command} object itself, with working directory updated.
}

\itemize{
\item \code{cmd_envvar}: The \code{command} object itself, with running environment
variable updated.
}

\itemize{
\item \code{cmd_envpath}: The \code{command} object itself, with running environment
variable specified in \code{name} updated.
}

\itemize{
\item \code{cmd_conda}: The \code{command} object itself, with running environment
variable \code{PATH} updated.
}
}
\description{
Setup the context for the command
}
\section{Functions}{
\itemize{
\item \code{cmd_wd()}: define the working directory.

\item \code{cmd_envvar()}: define the environment variables.

\item \code{cmd_envpath()}: define the \code{PATH}-like environment variables.

\item \code{cmd_conda()}: Set \code{conda-like} path to the \code{PATH} environment
variables.

}}
\seealso{
\itemize{
\item \code{\link[=cmd_run]{cmd_run()}}/\code{\link[=cmd_help]{cmd_help()}}/\code{\link[=cmd_background]{cmd_background()}}
\item \code{\link[=cmd_on_start]{cmd_on_start()}}/\code{\link[=cmd_on_exit]{cmd_on_exit()}}
\item \code{\link[=cmd_on_succeed]{cmd_on_succeed()}}/\code{\link[=cmd_on_fail]{cmd_on_fail()}}
\item \code{\link[=cmd_parallel]{cmd_parallel()}}
}
}
