% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate_standardise_measures.R
\name{boilerplate_measures_report}
\alias{boilerplate_measures_report}
\title{Report on Measure Database Quality}
\usage{
boilerplate_measures_report(db, measure_names = NULL, return_report = FALSE)
}
\arguments{
\item{db}{List. Measures database to analyse.}

\item{measure_names}{Character vector. Specific measures to analyse. If NULL, analyses all.}

\item{return_report}{Logical. If TRUE, returns a data frame report. Default is FALSE.}
}
\value{
If return_report is TRUE, returns a data frame with quality metrics.
}
\description{
Analyses a measures database and reports on completeness and consistency.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise and import
boilerplate_init(data_path = temp_dir, categories = "measures",
                 create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
unified_db <- boilerplate_import(data_path = temp_dir, quiet = TRUE)

# Get a quality report
report <- boilerplate_measures_report(unified_db$measures, return_report = TRUE)

# Just print summary
boilerplate_measures_report(unified_db$measures)

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
