% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findBestEpsilon.R
\name{findBestEpsilon}
\alias{findBestEpsilon}
\title{Optimal Size of Small Sets}
\usage{
findBestEpsilon(x, s = median(x), plotIt = FALSE)
}
\arguments{
\item{x}{A numeric vector representing a Markov chain.}

\item{s}{A real number specifying the center of the small set.
Default is the median of \code{x}.}

\item{plotIt}{Logical. If \code{TRUE} plots the estimated expected number of
regenerations as a
function of the radius \eqn{\epsilon}.}
}
\value{
Returns an object of class \code{smallEnsemble}, which is a list containing:
\itemize{
\item \code{s}: the chosen center of the small set,
\item \code{epsilon}: estimated optimal radius of the small set,
\item \code{delta}: estimated lower bound of the transition density over the optimal
small set,
\item \code{trans}: estimated values of \eqn{p_n(X_i,X_{i+1})}.
}
}
\description{
Determines the optimal radius \eqn{\epsilon} of small sets, which maximizes the
expected number of regeneration blocks.
Useful for identifying the parameters for splitting a Markov chain into almost
independent blocks.
}
\details{
The \code{findBestEpsilon} calculates the optimal radius \eqn{\epsilon} and the
corresponding lower bound \eqn{\delta} of the transition density for choosing the
optimal small set of a Markov chain given the center \code{s} of a small set.
It uses the \code{fastNadaraya} function to estimate
the transition density \eqn{p_n(X_i,X_{i+1})} taken at points \eqn{(X_i,X_{i+1})}.
}
\examples{
\donttest{
n=200 # the length of the process
# Generating the AR(1) process
sigma=1
coeff=0.75
X=arima.sim(n=n,list(ar=coeff, sd=sigma))
# Find the small ensemble with the largest number of regeneration
sm <- findBestEpsilon(X,s=0,plotIt=FALSE)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P. and Clémençon, S. (2006). Regenerative block bootstrap for Markov
chains. \emph{Bernoulli}, \bold{12}, 689-712.
}
\seealso{
\code{\link{regenboot}}, \code{\link{fastNadaraya}}, \code{\link{naradamar}},
\code{\link{GetBlocks}}, \code{\link{GetPseudoBlocks}}, \code{\link{smallEnsemble}}.
}
\keyword{"Markov}
\keyword{"Optimal}
\keyword{"Regenerative}
\keyword{Block}
\keyword{Bootstrap"}
\keyword{chains"}
\keyword{set"}
\keyword{small}
