% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackFuncRegen.R
\name{jackFuncRegen}
\alias{jackFuncRegen}
\title{Jackknife Variance Function for Markov Chains Using Regenerative Blocks}
\usage{
jackFuncRegen(func, atom = atom, small = NULL, ...)
}
\arguments{
\item{func}{A function for which the statistic and the jackknife variance
are to be calculated.}

\item{atom}{A numeric value or a string; an atom of the Markov chain..}

\item{small}{An optional object of class \code{\link{smallEnsemble}}. It can be
created optimally using \code{\link{findBestEpsilon}}.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns an object which is a function.
}
\description{
Creates a function that calculates both a specified statistic
and its jackknife variance estimator based on regenerative blocks for Markov chains.
}
\details{
This function is designed for use with regenerative data,
such as Markov chains. It employs regeneration-based methods
to estimate the jackknife variance of a given statistic by omitting alternatively
each block to compute the function of interest. This function is
particularly useful in conjunction with functions like \code{regenboot} and
provides an alternative to block-based methods like \code{jackFuncBlock}.
}
\examples{
x=genMM1(100,1,2)
#' # A function to compute the mean of strictly positive values and its variance based on
# regenerative blocks
func <- function(x) {mean(x*(x>0))}
jfb <- jackFuncRegen(func, atom=0)
# Regenerative bootstrap of the mean of strictly positive values and its variance allows
# to construct bootstrap-t confidence intervals
boo <- regenboot(x,jfb,99, atom=0)
confint(boo, method="all")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Quenouille, M.H. (1949). Approximate tests of correlation in time-series.
\emph{J. Roy. Statist. Soc., Ser. B}, \bold{11}, 68-84.
}
\seealso{
\code{\link{jackVar}},
\code{\link{jackFunc}},
\code{\link{regenboot}},
\code{\link{jackVarBlock}},
\code{\link{jackFuncBlock}}.
}
\keyword{Jackknife}
