% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF_model_test.R
\name{GOF_model_test}
\alias{GOF_model_test}
\title{R6 Class representing the Goodness-of-Fit test
  for (linear) models.}
\description{
This class can test the null hypothesis that data follows
  a particular linear model, i.e. classical linear models, generalized
  linear models or models of the type \eqn{m(\beta^\top X) + \epsilon}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GOF_model_test-new}{\code{GOF_model_test$new()}}
\item \href{#method-GOF_model_test-get_Rn1_org}{\code{GOF_model_test$get_Rn1_org()}}
\item \href{#method-GOF_model_test-get_Rn1_boot}{\code{GOF_model_test$get_Rn1_boot()}}
\item \href{#method-GOF_model_test-get_pvalue}{\code{GOF_model_test$get_pvalue()}}
\item \href{#method-GOF_model_test-clone}{\code{GOF_model_test$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GOF_model_test-new"></a>}}
\if{latex}{\out{\hypertarget{method-GOF_model_test-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_test$new(
  model,
  data,
  nmb_boot_samples,
  y_name,
  Rn1_statistic,
  gof_model_info_extractor,
  gof_model_resample
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{a fitted model}

\item{\code{data}}{used to fit \code{model}}

\item{\code{nmb_boot_samples}}{integer specifying the number of bootstrap
samples to perform}

\item{\code{y_name}}{string specifying the name of the dependent variable in
in \code{data}}

\item{\code{Rn1_statistic}}{statistic used to map the marked empirical
process to the real line. Needs to be an instance of the class
that implements \link{Rn1_statistic}}

\item{\code{gof_model_info_extractor}}{an instance that implements
\link{GOF_model_info_extractor} in order to apply it to
\code{model}}

\item{\code{gof_model_resample}}{an instance that implements
\link{GOF_model_resample} in order to apply it to
\code{model}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of the Class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GOF_model_test-get_Rn1_org"></a>}}
\if{latex}{\out{\hypertarget{method-GOF_model_test-get_Rn1_org}{}}}
\subsection{Method \code{get_Rn1_org()}}{
calculates the marked empricial process for \code{model}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_test$get_Rn1_org()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
vector ordered by the inner product of the estimated
  parameter and the independent variables
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GOF_model_test-get_Rn1_boot"></a>}}
\if{latex}{\out{\hypertarget{method-GOF_model_test-get_Rn1_boot}{}}}
\subsection{Method \code{get_Rn1_boot()}}{
calculates the marked empricial process for the
  resampled versions of \code{model}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_test$get_Rn1_boot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list of length \code{nmb_boot_samples} where every element
  is a vector ordered by the inner product of the estimated
  parameter and the dependent variables
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GOF_model_test-get_pvalue"></a>}}
\if{latex}{\out{\hypertarget{method-GOF_model_test-get_pvalue}{}}}
\subsection{Method \code{get_pvalue()}}{
p-value for Goodness-of-Fit-test for \code{model}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_test$get_pvalue()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
p-value for the null hypothesis that the dependent variable
  was generated according to \code{model}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GOF_model_test-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GOF_model_test-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_test$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
