% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bp_rats}
\alias{bp_rats}
\title{Blood Pressure in Salt-Sensitive Dahl Rats Data}
\format{
A data frame containing 5 variables pertaining to arterial continuous waveform blood
pressure as follows:
\describe{

\item{rat_type}{The type of a particular Dahl Rat (either SS or SSBN13) corresponding to the sodium intake administered:\cr\cr
ss_hs = SS rat given the high sodium diet\cr
ss_ls = SS rat given the low sodium diet\cr
ssbn13_hs = SSBN13 rat given the high sodium diet\cr
ssbn13_ls = SSBN13 rat given the low sodium diet\cr}
\item{rat_ID}{ID # corresponding to a particular rat. There are 9 SS rats and 6 SSBN13 rats.}
\item{ABP}{Continuous waveform data of each rat's arterial (blood) pressure sampled at 100 Hz.}
\item{time_sec}{Amount of time elapsed, expressed in seconds}
\item{time_min}{Amount of time elapsed, expressed in minutes}

}
}
\source{
Original Paper: \doi{10.1152/physiolgenomics.00027.2010}

Data: \doi{10.13026/C20597}
}
\usage{
bp_rats
}
\description{
The \code{bp_rats} data set includes arterial blood pressure waveform time series data
of the SS(n = 9) and SS.13 (n = 6) genetic strains of Dahl rats sampled at 100 Hz who
were each administered a low and high salt diet. It is taken from the study of Bugenhagen
et al.(2010) which sought to investigate the origins of the baroreflex dysfunction in
salt-sensitive Dahl rats on Hypertension.
}
\details{
(Goldberger A., Amaral L., Glass L., Hausdorff J., Ivanov P. C., Mark R., Bugenhagen S.M.,
Cowley A.W. Jr, Beard D.A., ... & Stanley H. E. 2000).

Licensed under a ODC-BY (Creative Commons) Open Data Commons Attribution License 1.0
}
\keyword{datasets}
