% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flippedBraid.R
\name{fitBraidFlipped}
\alias{fitBraidFlipped}
\alias{fitProtectiveBraid_A}
\alias{fitProtectiveBraid_B}
\alias{fitOppositionalBraid_A}
\alias{fitOppositionalBraid_B}
\alias{fitCoactiveBraid_pure}
\alias{fitCoactiveBraid_partial}
\title{Fit Flipped BRAID Surfaces}
\usage{
fitBraidFlipped(formula, data, flip, model, links = NULL, ...)

fitProtectiveBraid_A(formula, data, ...)

fitProtectiveBraid_B(formula, data, ...)

fitOppositionalBraid_A(formula, data, ...)

fitOppositionalBraid_B(formula, data, ...)

fitCoactiveBraid_pure(formula, data, ...)

fitCoactiveBraid_partial(formula, data, ...)
}
\arguments{
\item{formula}{Either an object of class \code{formula} such as would be provided
to a modeling function like \code{\link[stats:lm]{stats::lm()}}, or a width-2 numeric array vector
of concentration pairs (including 0 or Inf).  A formula should specify a
single output as a function of two inputs, eg. \code{activity ~ conc1 + conc2}.}

\item{data}{If \code{forumula} is a symbolic formula, a data frame containing the
specified values. If \code{formula} is a numeric array of concentrations, a
numeric vector of response values, the same length as the number of rows of
\code{formula}.}

\item{flip}{String specifying the direction or directions of the surface's
flip.  Must be one of "A", "B", or "both".}

\item{model, links}{Parameters \code{model} and \code{links} are used to specify which
variant of the BRAID model is fit to data.  Model may be one of the
following character strings: "kappa1", "kappa2", or "kappa3" (see Details),
or a subset of the numbers 1 through 9 specifying which of the nine BRAID
response surface parameters is allowed to vary when fitting.  \code{links} allows
the user to further specify constraints on the three BRAID maximal effect
parameters (see Details for more).  If \code{model} is one of the supported
character strings, the parameter \code{links} will be ignored.}

\item{...}{Additional parameters to be passed to \code{braidrm}}
}
\value{
A fit object of class \code{braidrmflip}.  This structure contains the
exact same elements as an object of class \code{braidrm} (see \code{\link[=braidrm]{braidrm()}} for
details) along with one additional element: \code{flip}, a character value
specifying the direction that the surface is flipped.  The object's
\code{coefficients} and \code{flip} fields can be used to evaluate and invert the best
fit response surface using \code{\link[=evalFlippedBraidModel]{evalFlippedBraidModel()}} and
\code{\link[=invertFlippedBraidModel]{invertFlippedBraidModel()}}.
}
\description{
Functions to fit protective, oppoistional and coactive BRAID surfaces, and
more specific flipped surfaces if necessary.
}
\details{
Though \code{fitBraidFlipped} offers the option of fitting any flipped BRAID
surface model specified by \code{flip}, this is not recommended, as the interplay
between flipping paramteers and parameter constraints becomes very confusing
very quickly.  In nearly all cases, it is preferable to use one of the
pre-defined flipped fitting functions.

\code{fitProtectiveBraid_A} and \code{fitProtectiveBraid_B} fit "protective" surfaces
in which one drug has no effect in isolation, but attenuates or eliminates
the effect of the other.  \code{fitProtectiveBraid_A} generates a surface in which
drug A is active and is attenuated by drug B; \code{fitProtectiveBraid_B}
generates the reverse.

\code{fitOppositinalBraid_A} and \code{fitOppositionalBraid_B} produce "oppositional"
surfaces in which a second drug produces an effect that is in the opposite
direction to the first drug, but which is then overwhelmed by the effect of
the first drug at higher concentrations.  \code{fitProtectiveBraid_A} generates a
surface in which the maximal effect of drug A dominates a high concentrations,
\code{fitProtectiveBraid_B} generates the reverse.  Note that the \code{A} and \code{B} in
the function names specify which compound's effect is dominant, not the
direction of the underlying flip; in actuality the surfaces generated by
\code{fitProtectiveBraid_A} are produced by flipping along the \code{B} axis.

\code{fitCoactiveBraid_pure} and \code{fitCoactiveBraid_partial} produce "coactive"
surfaces, in which both drugs have no or minimal effect in isolation, but
produce a pronounced effect when both are present.  \code{fitCoactiveBraid_pure}
generates surfaces in which both drugs have no effect at all in isolation;
\code{fitCoactiveBraid_partial} generates surfaces in which either drug may have
a smaller partial effect in isolation.
}
\examples{
fbfit1 <- fitProtectiveBraid_A(measure ~ concA + concB,
                               protectiveExample, getCIs=FALSE)
coef(fbfit1)

fbfit2 <- fitOppositionalBraid_A(measure ~ concA + concB,
                                 oppositionalExample, getCIs=FALSE)
coef(fbfit2)

fbfit3 <- fitCoactiveBraid_pure(measure ~ concA + concB,
                                coactiveExample, getCIs=FALSE)
coef(fbfit3)
}
