% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-indicators.R
\docType{data}
\name{gdp}
\alias{gdp}
\alias{baro}
\alias{wea}
\alias{fcurve}
\title{Swiss Economic Indicators}
\usage{
gdp

baro

wea

fcurve
}
\description{
A collection of datasets containing economic indicators for Switzerland.
}
\details{
\itemize{
\item \code{baro}: The KOF barometer, a monthly business cycle indicator.
\item \code{fcurve}: The F-curve, a daily business cycle indicator.
\item \code{gdp}: Quarterly GDP data (real, seasonally adjusted).
\item \code{wea}: The Weekly Economic Activity (WEA) indicator.
}
}
\section{Datasets}{

\itemize{
\item \code{baro}:
\itemize{
\item Source: \href{https://datenservice.kof.ethz.ch/}{KOF Swiss Economic Institute}
\item Timeframe: January 2004 - December 2022
\item Frequency: Monthly
\item Format: A tibble with monthly observations and 2 variables:
\itemize{
\item \code{time}: Date, the month and year of the observation.
\item \code{values}: Numeric, the value of the KOF barometer.
}
}
\item \code{fcurve}:
\itemize{
\item Source: \href{https://github.com/dankaufmann/f-curve}{Burri and Kaufmann GitHub}
\item Timeframe: January 2004 - December 2022
\item Frequency: Daily
\item Format: A tibble with daily observations and 2 variables:
\itemize{
\item \code{time}: Date, the date of the observation.
\item \code{values}: Numeric, the value of the F-curve (inverted for compatibility).
}
}
\item \code{gdp}:
\itemize{
\item Source: \href{https://www.seco.admin.ch/}{SECO}
\item Timeframe: January 2004 - December 2022
\item Frequency: Quarterly
\item Format: A tibble with quarterly observations and 2 variables:
\itemize{
\item \code{time}: Date, the quarter and year of the observation.
\item \code{values}: Numeric, the real GDP (seasonally adjusted).
}
}
\item \code{wea}:
\itemize{
\item Source: \href{https://www.seco.admin.ch/}{SECO WEA Indicator}
\item Timeframe: January 2005 - December 2022
\item Frequency: Weekly
\item Format: A tibble with weekly observations and 2 variables:
\itemize{
\item \code{time}: Date, the week and year of the observation.
\item \code{values}: Numeric, the value of the WEA.
}
}
}
}

\examples{
# Load and plot `baro`
data(baro)
library(tsbox)
suppressMessages(ts_plot(baro))
}
\keyword{datasets}
