% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardControlbar.R, R/aliases.R
\name{bs4DashControlbar}
\alias{bs4DashControlbar}
\alias{controlbarMenu}
\alias{controlbarItem}
\alias{updateControlbarMenu}
\alias{updateControlbar}
\alias{dashboardControlbar}
\title{Create a Boostrap 4 dashboard right sidebar}
\usage{
bs4DashControlbar(
  ...,
  id = NULL,
  disable = FALSE,
  width = 250,
  collapsed = TRUE,
  overlay = TRUE,
  skin = NULL,
  pinned = NULL
)

controlbarMenu(
  ...,
  id = NULL,
  selected = NULL,
  type = c("tabs", "pills", "hidden"),
  vertical = FALSE,
  side = "left",
  .list = NULL
)

controlbarItem(title, ..., value = title, icon = NULL)

updateControlbarMenu(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  selected = NULL
)

updateControlbar(id, session = shiny::getDefaultReactiveDomain())

dashboardControlbar(
  ...,
  id = NULL,
  disable = FALSE,
  width = 250,
  collapsed = TRUE,
  overlay = TRUE,
  skin = NULL,
  pinned = NULL
)
}
\arguments{
\item{...}{Any UI element.}

\item{id}{Controlbar id.}

\item{disable}{If \code{TRUE}, the sidebar will be disabled.}

\item{width}{Controlbar width. This must either be a number which specifies the width
in pixels, or a string that specifies the width in CSS units. 250 px by default.}

\item{collapsed}{Whether the control bar on the right side is collapsed or not at start. TRUE by default.}

\item{overlay}{Whether the sidebar covers the content when expanded. Default to TRUE.}

\item{skin}{Controlbar skin. "dark" or "light". Matches the \link{dashboardPage} dark parameter
value.}

\item{pinned}{Whether to block the controlbar state (TRUE or FALSE). Default to NULL.}

\item{selected}{The \code{value} (or, if none was supplied, the \code{title})
of the tab that should be selected by default. If \code{NULL}, the first
tab will be selected.}

\item{type}{\describe{
\item{\code{"tabs"}}{Standard tab look}
\item{\code{"pills"}}{Selected tabs use the background fill color}
}}

\item{vertical}{Whether to displays tabs vertically. Default to FALSE.}

\item{side}{Tabs side: \code{"left"} or \code{"right"}.}

\item{.list}{In case of programmatically generated items. See example.}

\item{title}{Display title for tab}

\item{value}{The value that should be sent when \code{tabsetPanel} reports
that this tab is selected. If omitted and \code{tabsetPanel} has an
\code{id}, then the title will be used.}

\item{icon}{Optional icon to appear on the tab. This attribute is only
valid when using a \code{tabPanel} within a \code{\link[shiny:navbarPage]{navbarPage()}}.}

\item{session}{Shiny session object.}

\item{inputId}{The id of the \code{tabsetPanel}, \code{navlistPanel},
or \code{navbarPage} object.}
}
\description{
Build an adminLTE3 dashboard right sidebar
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      body = dashboardBody(
        actionButton(inputId = "controlbarToggle", label = "Toggle Controlbar")
      ),
      controlbar = dashboardControlbar(
        id = "controlbar",
        collapsed = FALSE,
        overlay = TRUE
      ),
      title = "updateControlbar"
    ),
    server = function(input, output, session) {
      observeEvent(input$controlbar, {
        if (input$controlbar) {
          showModal(modalDialog(
            title = "Alert",
            "The controlbar is opened.",
            easyClose = TRUE,
            footer = NULL
          ))
        }
      })

      observeEvent(input$controlbarToggle, {
        updateControlbar(id = "controlbar", session = session)
      })

      observe({
        print(input$controlbar)
      })
    }
  )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
