% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{pagination}
\alias{pagination}
\alias{paginationItem}
\alias{updatePagination}
\title{Bootstrap 4 pagination widget}
\usage{
pagination(
  ...,
  id = NULL,
  selected = NULL,
  align = c("center", "left", "right"),
  size = c("md", "sm", "lg"),
  previousBtn = "«",
  nextBtn = "»",
  .list = NULL
)

paginationItem(title, ..., value = title, icon = NULL, disabled = FALSE)

updatePagination(
  id,
  selected = NULL,
  disabled = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{...}{Slot for \link{paginationItem}.}

\item{id}{Unique widget id. For programmatic update.
See \link{updatePagination}.}

\item{selected}{Which element to select at start.}

\item{align}{Alignment.}

\item{size}{Buttons size.}

\item{previousBtn}{Previous button text.}

\item{nextBtn}{Next button text.}

\item{.list}{Programmatically generated \link{paginationItem}.}

\item{title}{Display title for tab}

\item{value}{The value that should be sent when \code{tabsetPanel} reports
that this tab is selected. If omitted and \code{tabsetPanel} has an
\code{id}, then the title will be used.}

\item{icon}{Optional icon to appear on the tab. This attribute is only
valid when using a \code{tabPanel} within a \code{\link[shiny:navbarPage]{navbarPage()}}.}

\item{disabled}{Whether to disable the item. Default to FALSE.}

\item{session}{Shiny session object.}
}
\value{
An HTML pagination container

An HTML tag.

Send a message from R to JS so as to update
the pagination widget on the client.
}
\description{
See \url{https://getbootstrap.com/docs/4.0/components/pagination/}.

Insert inside \link{pagination}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)

 shinyApp(
   ui = dashboardPage(
    header = dashboardHeader(),
    sidebar = dashboardSidebar(),
    body = dashboardBody(
     pagination(
       paginationItem("page1", box(title = "This is a box!")),
       paginationItem("page2", "This is page 2", disabled = TRUE),
       paginationItem("page3", "This is page 3", disabled = TRUE),
       paginationItem(
         "page4",
         sliderInput(
           "obs",
           "Number of observations:",
           min = 0,
           max = 1000,
           value = 500
         ),
         plotOutput("distPlot"),
         icon = icon("cog")
       )
     )
    )
   ),
   server = function(input, output, session) {
     output$distPlot <- renderPlot({
       hist(rnorm(input$obs))
     })
   }
 )
}

if (interactive()) {
 library(shiny)
 library(bs4Dash)

 shinyApp(
   ui = dashboardPage(
    header = dashboardHeader(),
    sidebar = dashboardSidebar(),
    body = dashboardBody(
     fluidRow(
       actionButton("update", "Select page 4", class = "mx-2"),
       actionButton("disable", "Disable page 1", class = "mx-2"),
       actionButton("enable", "Enable page 1", class = "mx-2"),
       textOutput("selected_page")
     ),
     br(),
     br(),
     pagination(
       id = "mypagination",
       paginationItem("page1", box(title = "This is a box!")),
       paginationItem("page2", "This is page 2", disabled = TRUE),
       paginationItem("page3", "This is page 3"),
       paginationItem(
         "page4",
         sliderInput(
           "obs",
           "Number of observations:",
           min = 0,
           max = 1000,
           value = 500
         ),
         plotOutput("distPlot"),
         icon = icon("cog")
       )
     )
    )
   ),
   server = function(input, output, session) {

     observeEvent(input$update,{
       updatePagination("mypagination", selected = "page4")
     })

     observeEvent(input$disable,{
       updatePagination("mypagination", disabled = "page1")
     })

     observeEvent(input$enable,{
       updatePagination("mypagination", selected = "page1")
     })

     output$selected_page <- renderText({
       sprintf("Currently selected page: \%s", input$mypagination)
     })

     output$distPlot <- renderPlot({
       hist(rnorm(input$obs))
     })
   }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
