% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{compute_impulse_responses.PosteriorBSVARSIGN}
\alias{compute_impulse_responses.PosteriorBSVARSIGN}
\title{Computes posterior draws of impulse responses}
\usage{
\method{compute_impulse_responses}{PosteriorBSVARSIGN}(posterior, horizon, standardise = FALSE)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARSIGN} obtained by running the \code{estimate} function.}

\item{horizon}{a positive integer number denoting the forecast horizon for the impulse responses computations.}

\item{standardise}{a logical value. If \code{TRUE}, the impulse responses are standardised 
so that the variables' own shocks at horizon 0 are equal to 1. Otherwise, the parameter estimates 
determine this magnitude.}
}
\value{
An object of class PosteriorIR, that is, an \code{NxNx(horizon+1)xS} array with attribute PosteriorIR 
containing \code{S} draws of the impulse responses.
}
\description{
Each of the draws from the posterior estimation of models from 
packages \pkg{bsvars} or \pkg{bsvarSIGNs} is transformed into
a draw from the posterior distribution of the impulse responses.
}
\examples{
# upload data
data(optimism)

# specify the model and set seed
set.seed(123)

# + no effect on productivity (zero restriction)
# + positive effect on stock prices (positive sign restriction) 
sign_irf       = matrix(c(0, 1, rep(NA, 23)), 5, 5)
specification  = specify_bsvarSIGN$new(optimism, sign_irf = sign_irf)

# estimate the model
posterior      = estimate(specification, 10)

# compute impulse responses 2 years ahead
irf           = compute_impulse_responses(posterior, horizon = 8)

# workflow with the pipe |>
############################################################
set.seed(123)
optimism |>
  specify_bsvarSIGN$new(sign_irf = sign_irf) |> 
  estimate(S = 10) |> 
  compute_impulse_responses(horizon = 8) -> ir


}
\references{
Kilian, L., & Lütkepohl, H. (2017). Structural VAR Tools, Chapter 4, In: Structural vector autoregressive analysis. Cambridge University Press.
}
\seealso{
\code{\link{estimate.BSVARSIGN}}, \code{\link{summary}}, \code{\link{plot}}
}
\author{
Xiaolei Wang \email{adamwang15@gmail.com} and Tomasz Woźniak \email{wozniak.tom@pm.me}
}
