% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rmst_estimate.R
\name{get_rmst_estimate}
\alias{get_rmst_estimate}
\title{Calculate the marginal restricted mean survival time (RMST) when adjusting covariates in clinical trials}
\usage{
get_rmst_estimate(
  time,
  status,
  trt,
  covariates = NULL,
  tau,
  SE = "delta",
  n.boot = 1000,
  seed = 1
)
}
\arguments{
\item{time}{A vector containing the event time of the sample.}

\item{status}{A vector containing the survival status of the sample.}

\item{trt}{A vector indicating the treatment assignment. 1 for treatment group. 0 for placebo group.}

\item{covariates}{A data frame containing the covariates. If covariates is NULL, unadjusted RMST is returned.}

\item{tau}{Numeric. A value for the restricted time or the pre-specified cutoff time point.}

\item{SE}{Character. If SE = 'boot', SE was estimated using nonparametric bootstrap. If 'delta', SE was estimated using the delta method. Default is 'delta'.}

\item{n.boot}{Numeric. Number of bootstrap used. Only used if SE = 'boot'.}

\item{seed}{Numeric. Random seed for bootstrap. Default:1.}
}
\value{
A list including marginal RMST and SE.
}
\description{
Estimate the marginal RMST (point estimate) using the Karrison et al.(2018). Standard errors (SE) were estimated using the methods from Zucker (1998),
Chen and Tsiatis (2001), and Wei et al.(2023). We implemented both nonparametric(bootstrap) and parametric methods(delta) for SE.
}
\details{
Restricted mean survival time is a measure of average survival time up to a specified time point. We adopted the methods from Karrison et al.(2018) for
estimating the marginal RMST when adjusting covariates. For the SE, both nonparametric bootstrap and delta method are good for estimation. For the delta estimation of variance,we used a combined estimation including Zucker (1998) and Chen and Tsiatis (2001). SE (delta) = variance from Zucker (1998) + additional variance component from Chen and Tsiatis (2001).The additional variance is coming from treating covariates as random.
}
\examples{

data("oak")
tau <- 26
time <- oak$OS
status <- oak$os.status
trt <- oak$trt
covariates <- oak[, c("btmb", "pdl1")]
get_rmst_estimate(time, status, trt, covariates, tau, SE = "delta")
}
\references{
\itemize{
\item Karrison T, Kocherginsky M. Restricted mean survival time: Does covariate adjustment improve precision in randomized clinical trials? Clinical Trials. 2018;15(2):178-188. doi:10.1177/1740774518759281
\item Zucker, D. M. (1998). Restricted Mean Life with Covariates: Modification and Extension of a Useful Survival Analysis Method. Journal of the American Statistical Association, 93(442), 702–709. https://doi.org/10.1080/01621459.1998.10473722
\item Wei, J., Xu, J., Bornkamp, B., Lin, R., Tian, H., Xi, D., … Roychoudhury, S. (2024). Conditional and Unconditional Treatment Effects in Randomized Clinical Trials: Estimands, Estimation, and Interpretation. Statistics in Biopharmaceutical Research, 16(3), 371–381. https://doi.org/10.1080/19466315.2023.2292774
\item Chen, P. and Tsiatis, A. (2001), “Causal Inference on the Difference of the Restricted Mean Lifetime Between Two Groups,” Biometrics; 57: 1030–1038. DOI: 10.1111/j.0006-341x.2001.01030.x.
}
}
