% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calba.R
\name{ba_simple}
\alias{ba_simple}
\title{Calculate Simple Basal Area}
\usage{
ba_simple(
  sp,
  gx,
  gy,
  ba,
  r,
  dist_weighted = FALSE,
  edge_correction = c("none", "safe"),
  bounds = NULL
)
}
\arguments{
\item{sp}{A character vector containing species names for each tree.}

\item{gx}{A numeric vector of x-coordinates for the trees (e.g., 0 to 10 for realistic spatial data).}

\item{gy}{A numeric vector of y-coordinates for the trees (e.g., 0 to 10 for realistic spatial data).}

\item{ba}{A numeric vector of basal area values for the trees (e.g., cross-sectional area at breast height).}

\item{r}{A numeric scalar for the radius parameter. This parameter represents the maximum distance
to consider when summing basal areas of neighboring trees (e.g., 1–5 units for spatially distributed data).}

\item{dist_weighted}{Logical. If `TRUE`, use the distance-weighted approach (`ba / dist`);
if `FALSE`, use the unadjusted `ba`.}

\item{edge_correction}{Character. Use `"none"` (default) to return all focal trees or `"safe"`
to skip neighborhood calculations for trees within `r` of the plot edges and mark their output
as `NA`.}

\item{bounds}{Optional numeric vector `c(xmin, xmax, ymin, ymax)` giving the plot extent.
When `NULL`, the range of `gx`/`gy` is used; supply bounds if your data do not span the full plot.}
}
\value{
A list with two numeric vectors:
\describe{
  \item{`con_ba`}{A numeric vector representing the cumulative basal area of conspecific trees within the radius.}
  \item{`total_ba`}{A numeric vector representing the cumulative basal area of all trees (conspecific + heterospecific) within the radius.}
}
}
\description{
This function calculates the total basal area (conspecific + heterospecific) for a given set of tree data,
focusing on the number of focal trees and a radius parameter. The basal area represents the cumulative
cross-sectional area of tree trunks, either unadjusted or adjusted for a simple distance-weighted decay model.
}
\details{
The function either:
  - Calculates the unadjusted basal area if `dist_weighted = FALSE`.
  - Applies a simple distance-weighted approach (`ba / dist`) if `dist_weighted = TRUE`.
}
\examples{
# Generate a sample dataset
set.seed(42)  # For reproducibility
sample_data <- data.frame(
  latin = sample(letters[1:4], 100, replace = TRUE),
  gx = runif(100, 0, 10),  # Spatial coordinates between 0 and 10
  gy = runif(100, 0, 10),
  ba = runif(100, 10, 30)  # Basal area between 10 and 30
)

# Calculate with distance weighting
ba_simple(
  sp = sample_data$latin,
  gx = sample_data$gx,
  gy = sample_data$gy,
  ba = sample_data$ba,
  r = 3,  # Radius within the spatial scale
  dist_weighted = TRUE
)

# Calculate without distance weighting
ba_simple(
  sp = sample_data$latin,
  gx = sample_data$gx,
  gy = sample_data$gy,
  ba = sample_data$ba,
  r = 3,
  dist_weighted = FALSE
)

}
