% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian.R
\name{gregorian_date}
\alias{gregorian_date}
\alias{as_gregorian}
\title{Gregorian calendar dates}
\usage{
gregorian_date(year = integer(), month = integer(), day = integer())

as_gregorian(date)
}
\arguments{
\item{year}{A numeric vector of years}

\item{month}{A numeric vector of months}

\item{day}{A numeric vector of days}

\item{date}{Vector of dates on some calendar}
}
\value{
A gregorian vector object
}
\description{
The Gregorian calendar is the standard calendar used by most of the world. It
was named for Pope Gregory XIII who introduced it in 1582. It is a modification
of the Julian calendar which was in use at the time.
}
\examples{
new_date(year = 2025, month = 3, day = 2:4, calendar = cal_gregorian)
gregorian_date(2025, 4, 19:30)
as_date(Sys.Date(), calendar = cal_gregorian)
as_gregorian(Sys.Date())
as_gregorian("2016-01-01")
tibble::tibble(
  x = seq(as.Date("2025-01-01"), as.Date("2025-12-31"), by = "day"),
  y = as_gregorian(x),
  z = as_date(x, calendar = cal_gregorian)
)
}
\seealso{
\link{cal_gregorian}
}
