% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterRecordTable.R
\name{filterRecordTable}
\alias{filterRecordTable}
\title{Filter species record table for temporal independence}
\usage{
filterRecordTable(
  recordTable,
  minDeltaTime = 0,
  deltaTimeComparedTo,
  speciesCol = "Species",
  stationCol,
  cameraCol,
  camerasIndependent,
  recordDateTimeCol = "DateTimeOriginal",
  recordDateTimeFormat = "ymd HMS",
  removeDuplicateRecords = TRUE,
  exclude,
  timeZone,
  writecsv = FALSE,
  outDir,
  eventSummaryColumn,
  eventSummaryFunction,
  quiet = FALSE
)
}
\arguments{
\item{recordTable}{data frame as created by \code{\link{recordTable}}.}

\item{minDeltaTime}{integer. Time difference between records of the same
species at the same station to be considered independent (in minutes)}

\item{deltaTimeComparedTo}{character. For two records to be considered
independent, must the second one be at least \code{minDeltaTime} minutes
after the last independent record of the same species
(\code{"lastIndependentRecord"}), or \code{minDeltaTime} minutes after the
last record (\code{"lastRecord"})?}

\item{speciesCol}{character. name of the column specifying species in 
\code{recordTable}}

\item{stationCol}{character. Name of the camera trap station column.
Assuming "Station" if undefined.}

\item{cameraCol}{character. Name of the column specifying cameras in 
\code{recordTable} (optional).}

\item{camerasIndependent}{logical. If \code{TRUE}, species records are
considered to be independent between cameras at a station.}

\item{recordDateTimeCol}{character. Name of the column specifying date and 
time in \code{recordTable}.}

\item{recordDateTimeFormat}{character. Format of column 
\code{recordDateTimeCol} in \code{recordTable}}

\item{removeDuplicateRecords}{logical. If there are several records of the
same species at the same station (also same camera if cameraID is defined)
at exactly the same time, show only one?}

\item{exclude}{character. Vector of species names to be excluded from the
record table}

\item{timeZone}{character. Must be a value returned by
\code{\link[base:timezones]{OlsonNames}}}

\item{writecsv}{logical. Should the record table be saved as a .csv?}

\item{outDir}{character. Directory to save csv to. If NULL and
\code{writecsv = TRUE}, recordTable will be written to \code{inDir}.}

\item{eventSummaryColumn}{character. A column in the record table (e.g. from
a metadata tag) by to summarise non-independent records (those within
\code{minDeltaTime} of a given record) with a user-defined function
(\code{eventSummaryFunction})}

\item{eventSummaryFunction}{character. The function by which to summarise
\code{eventSummaryColumn} of non-independent records, e.g. "sum", "max"
(optional)}

\item{quiet}{logical. If TRUE, suppress printing of progress.}
}
\value{
A data frame containing species records and additional information
about stations, date, time, filtered for temporal independence.
}
\description{
Filter species record table for temporal independence
}
\examples{

if (Sys.which("exiftool") != ""){        # only run example if ExifTool is available

# set directory with camera trap images in station directories
wd_images_ID_species <- system.file("pictures/sample_images_species_dir", 
                                    package = "camtrapR")
                                    
# create record table without temporal filtering
rec_table <- recordTable(inDir                  = wd_images_ID_species,
                        IDfrom                 = "directory",
                        minDeltaTime           = 0,
                        exclude                = "UNID",
                        timeZone               = "Asia/Kuala_Lumpur",
                        removeDuplicateRecords = TRUE
                        )
                        
# filter for 60 minutes temporal independence
rec_table_filt <- filterRecordTable(recordTable         = rec_table, 
                                    minDeltaTime        = 60, 
                                    stationCol          = "Station",
                                    deltaTimeComparedTo = "lastIndependentRecord")
 nrow(rec_table)
 nrow(rec_table_filt)
 
 }
}
\author{
Juergen Niedballa
}
