% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_sme_plots.R
\name{batch_sme_plots}
\alias{batch_sme_plots}
\title{Batch SME Plots}
\usage{
batch_sme_plots(data, output_path = NULL)
}
\arguments{
\item{data}{A data frame or path to a CSV file with columns "sic_code", "turnover", and optionally "company_name".}

\item{output_path}{Optional directory to save plots. If NULL, plots are not saved.}
}
\value{
Donut chart plots showing scope 1 and 2 predicted emissions (in tCo2e) for each row in the data. Optionally saved to a directory as PNG files.
}
\description{
Batch plot SME Scope 1 & 2 emissions
}
\examples{
sample_data <- read.csv(system.file("extdata", "sme_examples.csv", package = "carbonpredict"))
sample_data <- head(sample_data, 3)
batch_sme_emissions <- batch_predict_emissions(
data = sample_data,
company_type = "sme",
output_path = NULL)
batch_sme_plots(data = batch_sme_emissions, output_path = NULL)
}
