% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survey_svyttest.R
\name{ard_survey_svyttest}
\alias{ard_survey_svyttest}
\title{ARD Survey t-test}
\usage{
ard_survey_svyttest(data, by, variables, conf.level = 0.95, ...)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a survey design object often created with \code{\link[survey:svydesign]{survey::svydesign()}}}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent tests will be run for each variable.}

\item{conf.level}{(\code{double})\cr
confidence level of the returned confidence interval. Must be between \code{c(0, 1)}.
Default is \code{0.95}}

\item{...}{arguments passed to \code{\link[survey:svyttest]{survey::svyttest()}}}
}
\value{
ARD data frame
}
\description{
Analysis results data for survey t-test using \code{\link[survey:svyttest]{survey::svyttest()}}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("survey", "broom")))) withAutoprint(\{ # examplesIf}
data(api, package = "survey")
dclus2 <- survey::svydesign(id = ~ dnum + snum, fpc = ~ fpc1 + fpc2, data = apiclus2)

ard_survey_svyttest(dclus2, variables = enroll, by = comp.imp, conf.level = 0.9)
\dontshow{\}) # examplesIf}
}
