% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretStack.R
\name{autoplot.caretStack}
\alias{autoplot.caretStack}
\title{Convenience function for more in-depth diagnostic plots of caretStack objects}
\usage{
\method{autoplot}{caretStack}(object, training_data = NULL, xvars = NULL, show_class_id = 2L, ...)
}
\arguments{
\item{object}{a \code{caretStack} object}

\item{training_data}{The data used to train the ensemble. Required if xvars is not NULL
Must be in the same row order as when the models were trained.}

\item{xvars}{a vector of the names of x variables to plot against residuals}

\item{show_class_id}{For classification only: which class level to show on the plot}

\item{...}{ignored}
}
\value{
A grid of diagnostic plots. Top left is the range of the performance
metric across each component model along with its standard deviation. Top right
is the residuals from the ensembled model plotted against fitted values.
Middle left is a bar graph of the weights of the component models. Middle
right is the disagreement in the residuals of the component models (unweighted)
across the fitted values. Bottom left and bottom right are the plots of the
residuals against two random or user specified variables. Note that the ensemble
must have been trained with savePredictions = "final", which is required to
get residuals from the stack for the plot.
}
\description{
This function provides a more robust series of diagnostic plots
for a caretEnsemble object.
}
\examples{
set.seed(42)
data(models.reg)
ens <- caretStack(models.reg[1:2], method = "lm")
autoplot(ens)
}
