% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_occurrences}
\alias{plot_occurrences}
\alias{plot_grid}
\alias{plot_predictors}
\alias{plot_scenarios}
\alias{plot_predictions}
\alias{mapview_grid}
\alias{mapview_occurrences}
\alias{mapview_predictors}
\alias{mapview_scenarios}
\alias{mapview_predictions}
\alias{plot_background}
\alias{plot_niche}
\title{S3 Methods for plot and mapview}
\usage{
plot_occurrences(i, spp_name = NULL, pa = TRUE, pa_id = 1)

plot_grid(i)

plot_predictors(i, variables_selected = NULL)

plot_scenarios(i, variables_selected = NULL, scenario = NULL)

plot_predictions(
  i,
  spp_name = NULL,
  scenario = NULL,
  id = NULL,
  ensemble = TRUE,
  ensemble_type = "mean_occ_prob"
)

mapview_grid(i)

mapview_occurrences(i, spp_name = NULL, pa = TRUE)

mapview_predictors(i, variables_selected = NULL)

mapview_scenarios(i, variables_selected = NULL, scenario = NULL)

mapview_predictions(
  i,
  spp_name = NULL,
  scenario = NULL,
  id = NULL,
  ensemble = TRUE,
  ensemble_type = "mean_occ_prob"
)

plot_background(i, variables_selected = NULL)

plot_niche(
  i,
  spp_name = NULL,
  variables_selected = NULL,
  scenario = NULL,
  id = NULL,
  ensemble = TRUE,
  ensemble_type = "mean_occ_prob",
  raster = FALSE
)
}
\arguments{
\item{i}{Object to be plotted. Can be a \code{input_sdm}, but also \code{occurrences} or
\code{sdm_area}.}

\item{spp_name}{A character with species to be plotted. If NULL, the first species is plotted.}

\item{pa}{Boolean. Should pseudoabsences be plotted together? (not implemented yet.)}

\item{pa_id}{The id of pseudoabsences to be plotted (only used when \code{pa = TRUE}). Possible
values are numeric values from 1 to number of PA sets.}

\item{variables_selected}{A character vector with names of variables to be plotted.}

\item{scenario}{description}

\item{id}{The id of models to be plotted (only used when \code{ensemble = FALSE}). Possible
values are row names of get_validation_metrics(i).}

\item{ensemble}{Boolean. Should the ensemble be plotted (TRUE)? Otherwise a prediction will be
plotted}

\item{ensemble_type}{Character of the type of ensemble to be plotted. One of: "mean_occ_prob",
"wmean_AUC" or "committee_avg"}

\item{raster}{Should the niche be extrapolated to a raster covering all possibe values in the
environmental space?}
}
\value{
The plot or mapview desired.
}
\description{
This function creates different plots depending on the input.
}
\details{
We implemented a bestiary of plots to help visualizing the process and results. If you
are not familiar with mapview, consider using it to better visualize maps.
}
\seealso{
\code{\link{WorldClim_data}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
