% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_sdm.R
\name{predict_sdm}
\alias{predict_sdm}
\alias{get_predictions}
\alias{get_ensembles}
\alias{add_predictions}
\title{Predict SDM models in new data}
\usage{
predict_sdm(m,
            scen = NULL,
            metric = "ROC",
            th = 0.9,
            tp = "prob",
            ensembles = TRUE,
            file = NULL,
            add.current = TRUE)

get_predictions(i)

get_ensembles(i)

add_predictions(p1, p2)
}
\arguments{
\item{m}{A \code{input_sdm} or a \code{models} object.}

\item{scen}{A \code{scenarios} object or \code{NULL}. If \code{NULL} and \code{m} is a
\code{input_sdm} with a scenarios slot, it will be used.}

\item{metric}{A character containing the metric in which the \code{th} will be
calculated/applied. Default is ROC. See \code{?mean_validation_metrics} for the metrics
available.}

\item{th}{Thresholds for metrics. Can be numeric or a function.}

\item{tp}{Type of output to be retrieved. See details.}

\item{ensembles}{Boolean. Should ensembles be calculated? If \code{TRUE} a series of ensembles
are obtained. See details.}

\item{file}{File to sabe predictions.}

\item{add.current}{If current scenario is not available, predictors will be used as the current
scenario.}

\item{i}{A \code{input_sdm} or a \code{predictions} object.}

\item{p1}{A \code{predictions} object.}

\item{p2}{A \code{predictions} object.}
}
\value{
A \code{input_sdm} or a \code{predictions} object.
}
\description{
This function projects SDM models to new scenarios
}
\details{
\code{tp} is a parameter to be passed on caret to retrieve either the probabilities of classes
(tp="prob") or the raw output (tp="raw"), which could vary depending on the algorithm used, but
usually would be on of the classes (factor vector with presences and pseudoabsences).

When \code{ensembles} is set to \code{TRUE}, three ensembles are currently implemented.
mean_occ_prob is the mean occurrence probability, which is a simple mean of predictions,
wmean_AUC is the same mean_occ_prob, but weighted by AUC, and committee_avg is the committee
average, as known as majority rule, where predictions are binarized and then a mean is obtained.

\code{get_predictions} returns the \code{list} of all predictions to all scenarios, all species,
all algorithms and all repetitions. Useful for those who wish to implement their own ensemble
methods.

\code{get_ensembles} returns a \code{matrix} of \code{data.frame}s, where each column is a
scenario and each row is a species.

\code{scenarios_names} returns the scenarios names in a \code{sdm_area} or \code{input_sdm}
object.

\code{get_scenarios_data} returns the data from scenarios in a \code{sdm_area} or
\code{input_sdm} object.
}
\examples{
# Create sdm_area object:
set.seed(1)
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="random", n_set=2)

# Custom trainControl:
ctrl_sdm <- caret::trainControl(method = "boot",
                                number = 1,
                                repeats = 1,
                                classProbs = TRUE,
                                returnResamp = "all",
                                summaryFunction = summary_sdm,
                                savePredictions = "all")

# Train models:
i <- train_sdm(i, algo = c("naive_bayes"), ctrl=ctrl_sdm) |>
  suppressWarnings()

# Predict models:
i  <- predict_sdm(i, th = 0.8)
i

}
\seealso{
\code{\link{sdm_area} \link{input_sdm} \link{mean_validation_metrics}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
