% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covar_sim.R
\name{covar_normal}
\alias{covar_normal}
\title{Simulate from multivariate normal distribution}
\usage{
covar_normal(
  n,
  normal.cor = NULL,
  normal.var = 1,
  names = c("z"),
  type = "cs",
  ...
)
}
\arguments{
\item{n}{Number of samples}

\item{normal.cor}{Correlation parameter (n x r) or (1 x r) matrix}

\item{normal.var}{marginal variance (can be specified as a p-dim. vector or
a nxp matrix)}

\item{names}{Column name of the column vector (default "z")}

\item{type}{of correlation matrix structure (cs: compound-symmetry /
exchangable, ar: autoregressive, un: unstructured, to: toeplitz). The
dimension of \code{normal.cor} must match, i.e., for a Toeplitz correlation
matrix r = p-1, and for a cs and ar r=1.}

\item{...}{Additional arguments passed to lower level functions}
}
\value{
list of data.tables
}
\description{
Simulate from MVN with compound symmetry variance structure and
mean zero. The result is returned as a list where the ith element is the
column vector with n observations from the ith coordinate of the MVN.
}
\seealso{
\link{outcome_count} \link{Trial} \link{covar_loggamma}
}
