% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertical-alignment.R
\name{vertical_alignment}
\alias{vertical_alignment}
\title{Vertical alignment}
\usage{
vertical_alignment(x, alignment)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{alignment}{A character string specifying an alignment. One of,
\itemize{
\item \code{"baseline"}
\item \code{"top"}
\item \code{"middle"}
\item \code{"bottom"}
\item \code{"text-top"}
\item \code{"text-bottom"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{vertical_alignment()} function adjusts the inline position of inline,
inline-block, and table cell elements. The utility may be used to adjust the
vertical alignment of an image in a line of text or the contents of a table
cell.
}
\examples{

library(htmltools)

div(
  "Text",
  span("Above") \%>\%
    vertical_alignment("top"),
  span("Below") \%>\%
    vertical_alignment("bottom")
)

}
