% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_data_lfc.R
\name{draw_data_lfc}
\alias{draw_data_lfc}
\title{Generate binary data (LFC model)}
\usage{
draw_data_lfc(
  n = 100,
  prev = c(0.5, 0.5),
  random = FALSE,
  m = 10,
  se = 0.8,
  sp = 0.8,
  B = round(m/2),
  L = 1,
  Rse = diag(rep(1, m)),
  Rsp = diag(rep(1, m)),
  modnames = paste0("model", 1:m),
  ...
)
}
\arguments{
\item{n}{(numeric) \cr integer, total sample size}

\item{prev}{(numeric) \cr disease and healthy prevalence (length 2, adds up to 1)}

\item{random}{(logical) \cr random sampling (TRUE) or fixed prevalence (FALSE)}

\item{m}{(numeric) \cr integer, number of models}

\item{se}{(numeric) \cr sensitivity (length 1)}

\item{sp}{(numeric) \cr specificity (length 1)}

\item{B}{(numeric) \cr integer, between 1 and m, specifies how many sensitivity values are projected to 1}

\item{L}{(numeric) \cr worst alternative is computed under side condition Acc <= L
(default value L=1 corresponds to true LFC where values are projected to 1)}

\item{Rse}{(matrix) \cr correlation matrix for empirical sensitivities (m x m)}

\item{Rsp}{(maxtrix) \cr correlation matrix for empirical specificities (m x m)}

\item{modnames}{(modnames) \cr character, model names (length m)}

\item{...}{(any) \cr further arguments (currently unused)}
}
\value{
(list) \cr list of matrices including generated binary datasets
(1: correct prediction, 0: incorrect prediction) for each subgroup (specificity, sensitivity)
}
\description{
Generate binary data (LFC model)
}
\examples{
data <- draw_data_lfc()
head(data)
}
