% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_pr_auc.r
\name{boot_worker_fn}
\alias{boot_worker_fn}
\title{Compute bootstrap replica of pr auc}
\usage{
boot_worker_fn(
  sampled_id_list,
  intermed_res,
  propensity_scored,
  replace_zero_division_with
)
}
\arguments{
\item{sampled_id_list}{A list of all doc_ids of the examples drawn in each
bootstrap iteration.}

\item{intermed_res}{Intermediate results as produced by
\code{compute_intermediate_results}, with a column \code{"searchspace_id"}
as grouping variable.}

\item{propensity_scored}{Logical, whether to use propensity scores as
weights.}

\item{replace_zero_division_with}{In macro averaged results (doc-avg, subj-avg), it may occur that some
instances have no predictions or no gold standard. In these cases,
calculating precision and recall may lead to division by zero. CASIMiR
standardly removes these missing values from macro averages, leading to a
smaller support (count of instances that were averaged). Other
implementations of macro averaged precision and recall default to 0 in these
cases. This option allows to control the default. Set any value between 0
and 1. (Defaults to \code{NULL}, overwritable using option 'casimir.replace_zero_division_with' or environment variable 'R_CASIMIR_REPLACE_ZERO_DIVISION_WITH')}
}
\value{
A data.frame with a column \code{"pr_auc"} and optional
\code{grouping_vars}.
}
\description{
A wrapper for use within bootstrap computation of pr auc which covers the
repeated application of:
\enumerate{
\item join with resampled doc_ids
\item summarise_intermediate_results
\item postprocessing of curve data
\item auc computation
}
}
