% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mach_cat}
\alias{mach_cat}
\title{Machiavellianism Personality Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \code{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.

See \url{https://openpsychometrics.org/_rawdata/}, maintained by Eric Jorgenson, for the raw Open Source Psychometrics Project data.
}
\usage{
data(mach_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 20 item machiavellianism inventory
}
\details{
Cat object containing item parameters for graded response model fit with
 3020 response profiles collected by Qualtrics in June 2018
and 12299 response profiles collected by the Open Source Psychometrics Project in 2012.

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the Qualtrics sample (-0.713) and a standard deviation (1)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are:
5 = Strongly agree, 4 = Somewhat agree, 3 = Neither agree nor disagree, 2 = Somewhat disagree, 1 = Strongly disagree

The wording of the item responses is: 

\describe{
\item{\code{Q1}}{ Never tell anyone the real reason you did something unless it is useful to do so.}
\item{\code{Q2}}{ The best way to handle people is to tell them what they want to hear.}
\item{\code{Q3}}{ One should take action only when sure it is morally right.}
\item{\code{Q4}}{ Most people are basically good and kind.}
\item{\code{Q5}}{ It is safest to assume that all people have a vicious streak and it will come out when they are given a chance.}
\item{\code{Q6}}{ Honesty is the best policy in all cases.}
\item{\code{Q7}}{ There is no excuse for lying to someone else.}
\item{\code{Q8}}{ Generally speaking, people won't work hard unless they're forced to do so.}
\item{\code{Q9}}{ All in all, it is better to be humble and honest than to be important and dishonest.}
\item{\code{Q10}}{ When you ask someone to do something for you, it is best to give the real reasons for wanting it rather than giving reasons which carry more weight.}
\item{\code{Q11}}{ Most people who get ahead in the world lead clean, moral lives.}
\item{\code{Q12}}{ Anyone who completely trusts anyone else is asking for trouble.}
\item{\code{Q13}}{ The biggest difference between most criminals and other people is that the criminals are stupid enough to get caught.}
\item{\code{Q14}}{ Most people are brave.}
\item{\code{Q15}}{ It is wise to flatter important people.}
\item{\code{Q16}}{ It is possible to be good in all respects.}
\item{\code{Q17}}{ P.T. Barnum was wrong when he said that there's a sucker born every minute.}
\item{\code{Q18}}{ It is hard to get ahead without cutting corners here and there.}
\item{\code{Q19}}{ People suffering from incurable diseases should have the choice of being put painlessly to death.}
\item{\code{Q20}}{ Most people forget more easily the death of their parents than the loss of their property.}
}
}
\references{
Christie, R., F. L. Geis, and D. Berger (1970), Studies in Machiavellianism, New York: Academic Press.

Open Source Psychometrics Project. \url{https://openpsychometrics.org/_rawdata/}
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
