% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plift.R
\encoding{UTF-8}
\name{plift}
\alias{plift}
\title{Penalty-Lift Analysis}
\usage{
plift(X, Y, digits = getOption("digits"), verbose = FALSE)
}
\arguments{
\item{X}{\emph{either} a matrix of CATA data with \eqn{I} consumers (rows)
and \eqn{J} products (columns) \emph{or} an array of CATA data with 
\eqn{I} consumers, \eqn{J} products, and \eqn{M} attributes.}

\item{Y}{matrix of hedonic data with \eqn{I} consumers (rows)
and \code{J} products (columns)}

\item{digits}{for rounding}

\item{verbose}{set to \code{TRUE} to report counts and averages for checked
and not checked conditions (default: \code{FALSE})}
}
\value{
Penalty lift per attribute, with counts and averages if \code{verbose} 
is \code{TRUE}.
}
\description{
Penalty-Lift analysis for CATA variables, which is the difference between
the average hedonic response when CATA attribute is checked vs. the average
hedonic response when CATA attribute is not checked.
}
\examples{
# penalty lift, based only on the first 12 consumers

# for the first attribute ("Fresh")
plift(bread$cata[1:12,,1], bread$liking[1:12, ], digits = 3) 

# for the first 3  attributes with counts and averages
plift(bread$cata[1:12,,1:3], bread$liking[1:12, ], digits = 3, verbose = TRUE) 
}
\references{
Meyners, M., Castura, J.C., & Carr, B.T. (2013). Existing and new 
approaches for the analysis of CATA data. \emph{Food Quality and Preference}, 
30, 309-319, \doi{10.1016/j.foodqual.2013.06.010}
}
\author{
J.C. Castura
}
