% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_glm_mean}
\alias{get_glm_mean}
\title{Compute Mean Based on GLM Family}
\usage{
get_glm_mean(family_string, X, coefs)
}
\arguments{
\item{family_string}{Character. The GLM family to use. Options are \code{"binomial"} or \code{"gaussian"}.}

\item{X}{Matrix. The design matrix (predictors) for the GLM.}

\item{coefs}{Numeric vector. The coefficients for the GLM.}
}
\value{
Numeric vector. The computed mean of the response variable based on the specified family.
}
\description{
This function calculates the mean of the response variable for a generalized linear model (GLM)
based on the specified family. The calculation depends on whether the family is binomial or gaussian.
}
