% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_standardized_data}
\alias{get_standardized_data}
\title{Standardize Data}
\usage{
get_standardized_data(data, na_replace = stats::na.omit)
}
\arguments{
\item{data}{A data frame to be standardized.}

\item{na_replace}{A function or numeric value used to replace NA values. If a function, it should take a vector and return a replacement value.
If a numeric value, it is used directly to replace NA values in continuous columns.
The default is \code{stats::na.omit}, which omits rows with NA values (used as an indicator here, not the actual replacement value).}
}
\value{
A data frame where columns have been converted to numeric or factor types, and NA values have been replaced according to the method specified.
}
\description{
This function standardizes a dataset by converting columns to numeric or factor types and replacing NA values.
For continuous variables, NA values are replaced with either a specific numeric value or a computed statistic.
For categorical variables, NA values are replaced with the mode of the column.
}
