% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hoffmanphantom}
\alias{hoffmanphantom}
\title{An example fMRI phantom}
\format{
a \eqn{128 \times 128 \times 2}{128 x 128 x 2} array with the
first slice an activation map for an MRI phantom and the second an
anatomical overlay. \code{NA} values are outside the surface. The
activation map (\code{hoffmanphantom[,,1]}) is 1 if activated,
0 otherwise. The second layer  (\code{hoffmanphantom[,,2]})
indicates the anatomical structure. Approximately 3.8 percent of the
pixels are activated in this slice.
}
\usage{
data(hoffmanphantom)
}
\description{
A \eqn{128 \times 128}{128 x 128} activation map for a slice of an fMRI
phantom and an anatomical reference.
}
\examples{
image(hoffmanphantom[, , 2], col = rev(gray(0:15 / 16))[1:4], axes = FALSE)
image(hoffmanphantom[, , 1],
  add = TRUE, zlim = c(0.01, 1),
  col = c("yellow", "maroon")
)
}
\references{
E. Hoffman, P. Cutler, W. Digby, and J. Mazziotta, “3-D phantom
to simulate cerebral blood flow and metabolic images for PET,”
Nuclear Science, IEEE Transactions on, vol. 37, pp. 616 – 620, 05
1990.

I. A. Almodóvar-Rivera and R. Maitra, “FAST adaptive smoothed
thresholding for improved activation detection in low-signal
fMRI,” IEEE Transactions on Medical Imaging, vol. 38, no. 12, pp.
2821–2828, 2019.
}
\keyword{datasets}
